"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_REQUIRED = exports.VALUE_LABEL = exports.TAGS_LABEL = exports.SHARED_LABEL = exports.NAMESPACES_LABEL = exports.KEY_LABEL = exports.DESCRIPTION_LABEL = exports.AddParamForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/security-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _optional_text = require("../components/optional_text");
var _param_value_field = require("./param_value_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddParamForm = ({
  items,
  isEditingItem
}) => {
  var _errors$key;
  const {
    register,
    control
  } = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = (0, _reactHookForm.useFormState)();
  const tagsList = items.reduce((acc, item) => {
    const tags = item.tags || [];
    return new Set([...acc, ...tags]);
  }, new Set());
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    noValidate: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: KEY_LABEL,
    isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.key),
    error: errors === null || errors === void 0 ? void 0 : (_errors$key = errors.key) === null || _errors$key === void 0 ? void 0 : _errors$key.message
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.key),
    "data-test-subj": "syntheticsAddParamFormFieldText",
    fullWidth: true,
    "aria-label": KEY_LABEL
  }, register('key', {
    required: {
      value: true,
      message: KEY_REQUIRED
    },
    validate: val => {
      return items.filter(param => isEditingItem ? param.id !== isEditingItem.id : true).some(param => param.key === val) ? KEY_EXISTS : undefined;
    }
  })))), /*#__PURE__*/_react.default.createElement(_param_value_field.ParamValueField, {
    isEditingItem: isEditingItem
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: TAGS_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, null)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "tags",
    render: ({
      field
    }) => {
      var _field$value$map, _field$value;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
        fullWidth: true,
        "aria-label": TAGS_LABEL,
        placeholder: TAGS_LABEL,
        isInvalid: !!(errors !== null && errors !== void 0 && errors.tags),
        selectedOptions: (_field$value$map = (_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.map(tag => ({
          label: tag,
          value: tag
        }))) !== null && _field$value$map !== void 0 ? _field$value$map : [],
        options: [...tagsList].map(tag => ({
          label: tag,
          value: tag
        })),
        onCreateOption: newTag => {
          var _field$value2;
          field.onChange([...((_field$value2 = field.value) !== null && _field$value2 !== void 0 ? _field$value2 : []), newTag]);
        }
      }, field, {
        onChange: selectedTags => {
          field.onChange(selectedTags.map(tag => tag.value));
        }
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: DESCRIPTION_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "syntheticsAddParamFormFieldText",
    fullWidth: true,
    "aria-label": DESCRIPTION_LABEL
  }, register('description', {})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: NAMESPACES_LABEL
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "namespaces",
    render: ({
      field
    }) => {
      var _field$value3, _field$value4;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "isShared",
        label: SHARED_LABEL,
        "aria-label": NAMESPACES_LABEL,
        onChange: e => {
          if (e.target.checked) {
            field.onChange([_public.ALL_SPACES_ID]);
          } else {
            field.onChange([]);
          }
        },
        checked: ((_field$value3 = field.value) !== null && _field$value3 !== void 0 ? _field$value3 : []).length > 0 && ((_field$value4 = field.value) !== null && _field$value4 !== void 0 ? _field$value4 : [])[0] === '*',
        disabled: Boolean(isEditingItem)
      });
    }
  })));
};
exports.AddParamForm = AddParamForm;
const KEY_LABEL = exports.KEY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.paramForm.keyLabel', {
  defaultMessage: 'Key'
});
const TAGS_LABEL = exports.TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.paramForm.tagsLabel', {
  defaultMessage: 'Tags'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.paramForm.descriptionLabel', {
  defaultMessage: 'Description'
});
const SHARED_LABEL = exports.SHARED_LABEL = _i18n.i18n.translate('xpack.synthetics.paramForm.sharedAcrossSpacesLabel', {
  defaultMessage: 'Share across spaces'
});
const NAMESPACES_LABEL = exports.NAMESPACES_LABEL = _i18n.i18n.translate('xpack.synthetics.paramForm.namespaces', {
  defaultMessage: 'Namespaces'
});
const VALUE_LABEL = exports.VALUE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.paramForm.paramLabel', {
  defaultMessage: 'Value'
});
const KEY_REQUIRED = _i18n.i18n.translate('xpack.synthetics.monitorManagement.param.keyRequired', {
  defaultMessage: 'Key is required'
});
const KEY_EXISTS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.param.keyExists', {
  defaultMessage: 'Key already exists'
});
const VALUE_REQUIRED = exports.VALUE_REQUIRED = _i18n.i18n.translate('xpack.synthetics.monitorManagement.value.required', {
  defaultMessage: 'Value is required'
});