"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorStatusData = exports.useBins = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _reactRouterDom = require("react-router-dom");
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _monitor_status_data = require("./monitor_status_data");
var _use_selected_location = require("../hooks/use_selected_location");
var _status_heatmap = require("../../../state/status_heatmap");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorStatusData = ({
  from,
  to,
  initialSizeRef
}) => {
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const location = (0, _use_selected_location.useSelectedLocation)();
  const pageLocation = (0, _reactRouterDom.useLocation)();
  const fromMillis = (0, _monitor_status_data.dateToMilli)(from);
  const toMillis = (0, _monitor_status_data.dateToMilli)(to);
  const totalMinutes = Math.ceil(toMillis - fromMillis) / (1000 * 60);
  const [binsAvailableByWidth, setBinsAvailableByWidth] = (0, _react.useState)(null);
  const [debouncedBinsCount, setDebouncedCount] = (0, _react.useState)(null);
  const minsPerBin = debouncedBinsCount !== null ? Math.floor(totalMinutes / debouncedBinsCount) : null;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    heatmap: dateHistogram,
    loading
  } = (0, _reactRedux.useSelector)(_status_heatmap.selectHeatmap);
  const getBinsNo = (0, _react.useCallback)(maxNoOfBins => {
    // Each bin represents a time interval of at least 1 minute. If the available width allows for more bins
    // than there are minutes in the time range, we cap the number of bins to match the number of minutes
    // to ensure each bin represents a meaningful time interval.
    return Math.min(maxNoOfBins, totalMinutes);
  }, [totalMinutes]);
  (0, _react.useEffect)(() => {
    if (binsAvailableByWidth === null && initialSizeRef !== null && initialSizeRef !== void 0 && initialSizeRef.current) {
      var _initialSizeRef$curre;
      setBinsAvailableByWidth(getBinsNo(Math.floor((initialSizeRef === null || initialSizeRef === void 0 ? void 0 : (_initialSizeRef$curre = initialSizeRef.current) === null || _initialSizeRef$curre === void 0 ? void 0 : _initialSizeRef$curre.clientWidth) / _monitor_status_data.CHART_CELL_WIDTH)));
    }
  }, [binsAvailableByWidth, initialSizeRef, getBinsNo]);
  (0, _react.useEffect)(() => {
    if (monitor !== null && monitor !== void 0 && monitor.id && location !== null && location !== void 0 && location.label && debouncedBinsCount !== null && !!minsPerBin) {
      dispatch(_status_heatmap.quietGetMonitorStatusHeatmapAction.get({
        monitorId: monitor.id,
        location: location.label,
        from,
        to,
        interval: minsPerBin
      }));
    }
  }, [dispatch, from, to, minsPerBin, location === null || location === void 0 ? void 0 : location.label, monitor === null || monitor === void 0 ? void 0 : monitor.id, lastRefresh, debouncedBinsCount]);
  (0, _react.useEffect)(() => {
    dispatch((0, _status_heatmap.clearMonitorStatusHeatmapAction)());
  }, [dispatch, pageLocation.pathname]);
  const handleResize = (0, _react.useCallback)(e => setBinsAvailableByWidth(getBinsNo(Math.floor(e.width / _monitor_status_data.CHART_CELL_WIDTH))), [getBinsNo]);
  (0, _useDebounce.default)(() => {
    setDebouncedCount(binsAvailableByWidth === 0 ? null : binsAvailableByWidth);
  }, 500, [binsAvailableByWidth]);
  const {
    timeBins,
    timeBinMap,
    xDomain
  } = useBins({
    fromMillis,
    toMillis,
    dateHistogram,
    minsPerBin
  });
  return {
    loading,
    minsPerBin,
    timeBins,
    getTimeBinByXValue: xValue => xValue === undefined ? undefined : timeBinMap.get(xValue),
    xDomain,
    handleResize
  };
};
exports.useMonitorStatusData = useMonitorStatusData;
const useBins = ({
  minsPerBin,
  fromMillis,
  toMillis,
  dateHistogram
}) => (0, _react.useMemo)(() => {
  var _bins$0$end, _bins$, _bins$at$end, _bins$at;
  if (minsPerBin === null) {
    return {
      timeBins: [],
      timeBinMap: new Map(),
      xDomain: {
        min: fromMillis,
        max: toMillis
      }
    };
  }
  const timeBuckets = (0, _monitor_status_data.createTimeBuckets)(minsPerBin !== null && minsPerBin !== void 0 ? minsPerBin : 50, fromMillis, toMillis);
  const bins = (0, _monitor_status_data.createStatusTimeBins)(timeBuckets, dateHistogram);
  return {
    timeBins: bins,
    timeBinMap: (0, _monitor_status_data.indexBinsByEndTime)(bins),
    xDomain: {
      min: (_bins$0$end = bins === null || bins === void 0 ? void 0 : (_bins$ = bins[0]) === null || _bins$ === void 0 ? void 0 : _bins$.end) !== null && _bins$0$end !== void 0 ? _bins$0$end : fromMillis,
      max: (_bins$at$end = bins === null || bins === void 0 ? void 0 : (_bins$at = bins.at(-1)) === null || _bins$at === void 0 ? void 0 : _bins$at.end) !== null && _bins$at$end !== void 0 ? _bins$at$end : toMillis
    }
  };
}, [minsPerBin, fromMillis, toMillis, dateHistogram]);
exports.useBins = useBins;