"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanelWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _add_to_dashboard = require("./add_to_dashboard");
var _constants = require("../../../../embeddables/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmbeddablePanelWrapper = ({
  children,
  title,
  loading,
  titleAppend,
  hideTitle
}) => {
  const isSyntheticsApp = window.location.pathname.includes('/app/synthetics');
  const noTitle = !title && !titleAppend;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: isSyntheticsApp
  }, !noTitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, (!hideTitle || !title) && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title))), isSyntheticsApp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_to_dashboard.AddToDashboard, {
    type: _constants.SYNTHETICS_STATS_OVERVIEW_EMBEDDABLE,
    isLoading: loading
  })), titleAppend && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, titleAppend)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), children));
};
exports.EmbeddablePanelWrapper = EmbeddablePanelWrapper;