"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByExpression = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupByExpression = ({
  onChange,
  groupByLocation,
  locationsThreshold
}) => {
  const disabledGroupBy = locationsThreshold > 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    disabled: disabledGroupBy,
    label: _i18n.i18n.translate('xpack.synthetics.groupByExpression.euiSwitch.groupByLabel', {
      defaultMessage: 'Receive distinct alerts for each location'
    }),
    checked: groupByLocation,
    onChange: e => onChange(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, disabledGroupBy ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.synthetics.groupByExpression.euiSwitch.tooltip', {
      defaultMessage: 'When locations threshold is greater than 1, group by location is disabled.'
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.synthetics.groupByExpression.euiSwitch.tooltip', {
      defaultMessage: 'When the monitor detects a failure on one or more locations, you receive an alert for each of these locations, instead of a single alert.'
    })
  })));
};
exports.GroupByExpression = GroupByExpression;