"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsOverviewComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _utils = require("../common/utils");
var _redux_store = require("./redux_store");
var _show_selected_filters = require("../common/show_selected_filters");
var _state = require("../../synthetics/state");
var _synthetics_embeddable_context = require("../synthetics_embeddable_context");
var _overview_status = require("../../synthetics/components/monitors_page/overview/overview/overview_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatsOverviewComponent = ({
  reload$,
  filters
}) => {
  const statsOverviewStore = (0, _react.useRef)((0, _redux_store.getStatsOverviewStore)());
  return /*#__PURE__*/_react.default.createElement(_synthetics_embeddable_context.SyntheticsEmbeddableContext, {
    reload$: reload$,
    reduxStore: statsOverviewStore.current
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(WithFiltersComponent, {
    filters: filters !== null && filters !== void 0 ? filters : {}
  }))));
};
exports.StatsOverviewComponent = StatsOverviewComponent;
const WithFiltersComponent = ({
  filters
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    var _filters$tags, _filters$locations, _filters$monitorTypes, _filters$monitorIds, _filters$projects;
    dispatch((0, _state.setOverviewPageStateAction)({
      tags: (_filters$tags = filters.tags) === null || _filters$tags === void 0 ? void 0 : _filters$tags.map(tag => tag.value),
      locations: (_filters$locations = filters.locations) === null || _filters$locations === void 0 ? void 0 : _filters$locations.map(location => location.value),
      monitorTypes: (_filters$monitorTypes = filters.monitorTypes) === null || _filters$monitorTypes === void 0 ? void 0 : _filters$monitorTypes.map(monitorType => monitorType.value),
      monitorQueryIds: (_filters$monitorIds = filters.monitorIds) === null || _filters$monitorIds === void 0 ? void 0 : _filters$monitorIds.map(monitorId => monitorId.value),
      projects: (_filters$projects = filters.projects) === null || _filters$projects === void 0 ? void 0 : _filters$projects.map(project => project.value)
    }));
  }, [dispatch, filters]);
  const hasFilters = !(0, _utils.areFiltersEmpty)(filters);
  return /*#__PURE__*/_react.default.createElement(_overview_status.OverviewStatus, {
    titleAppend: hasFilters ? /*#__PURE__*/_react.default.createElement(_show_selected_filters.ShowSelectedFilters, {
      filters: filters !== null && filters !== void 0 ? filters : {}
    }) : null,
    hideTitle: true,
    areStatsClickable: true
  });
};