"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSyntheticsEmbeddables = void 0;
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const registerSyntheticsEmbeddables = (core, pluginsSetup) => {
  pluginsSetup.embeddable.registerReactEmbeddableFactory(_constants.SYNTHETICS_STATS_OVERVIEW_EMBEDDABLE, async () => {
    const {
      getStatsOverviewEmbeddableFactory
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./stats_overview/stats_overview_embeddable_factory')));
    return getStatsOverviewEmbeddableFactory(core.getStartServices);
  });
  pluginsSetup.embeddable.registerReactEmbeddableFactory(_constants.SYNTHETICS_MONITORS_EMBEDDABLE, async () => {
    const {
      getMonitorsEmbeddableFactory
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./monitors_overview/monitors_embeddable_factory')));
    return getMonitorsEmbeddableFactory(core.getStartServices);
  });
};
exports.registerSyntheticsEmbeddables = registerSyntheticsEmbeddables;