"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routingDefinitionSchema = exports.routingDefinitionListSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _conditions = require("../../../conditions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routingDefinitionSchema = exports.routingDefinitionSchema = _zod.z.object({
  destination: _zodHelpers.NonEmptyString,
  if: _conditions.conditionSchema
});
const routingDefinitionListSchema = exports.routingDefinitionListSchema = _zod.z.array(routingDefinitionSchema);