"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignificantEventsApi = useSignificantEventsApi;
var _react = require("react");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSignificantEventsApi({
  name
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  return (0, _react.useMemo)(() => {
    return {
      addQuery: async ({
        kql,
        title,
        id
      }) => {
        await streamsRepositoryClient.fetch('PUT /api/streams/{name}/queries/{queryId} 2023-10-31', {
          signal,
          params: {
            path: {
              name,
              queryId: id
            },
            body: {
              kql,
              title
            }
          }
        });
      },
      removeQuery: async id => {
        await streamsRepositoryClient.fetch('DELETE /api/streams/{name}/queries/{queryId} 2023-10-31', {
          signal,
          params: {
            path: {
              name,
              queryId: id
            }
          }
        });
      },
      bulk: async operations => {
        await streamsRepositoryClient.fetch('POST /api/streams/{name}/queries/_bulk 2023-10-31', {
          signal,
          params: {
            path: {
              name
            },
            body: {
              operations
            }
          }
        });
      }
    };
  }, [name, signal, streamsRepositoryClient]);
}