"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignificantEventValidation = useSignificantEventValidation;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSignificantEventValidation({
  queryValues
}) {
  const validation = (0, _react.useMemo)(() => {
    const {
      title = '',
      kql: {
        query: kqlQuery
      } = {
        query: ''
      }
    } = queryValues;
    const titleEmptyError = title.length === 0;
    const kqlEmptyError = kqlQuery.length === 0;
    const titleErrorMessage = titleEmptyError ? _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldTitleRequiredError', {
      defaultMessage: 'Required'
    }) : undefined;
    let kqlSyntaxError = false;
    if (!kqlEmptyError) {
      try {
        (0, _esQuery.fromKueryExpression)(kqlQuery);
      } catch (error) {
        kqlSyntaxError = true;
      }
    }
    const kqlErrorMessage = kqlSyntaxError ? _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldQuerySyntaxError', {
      defaultMessage: 'Invalid syntax'
    }) : kqlEmptyError ? _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldQueryRequiredError', {
      defaultMessage: 'Required'
    }) : undefined;
    return {
      title: titleErrorMessage,
      kql: kqlErrorMessage
    };
  }, [queryValues]);
  return validation;
}