"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailSignificantEventsView = StreamDetailSignificantEventsView;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_significant_events = require("../../hooks/use_fetch_significant_events");
var _use_kibana = require("../../hooks/use_kibana");
var _use_significant_events_api = require("../../hooks/use_significant_events_api");
var _use_timefilter = require("../../hooks/use_timefilter");
var _loading_panel = require("../loading_panel");
var _streams_app_search_bar = require("../streams_app_search_bar");
var _timeline = require("../timeline");
var _change_point = require("./change_point");
var _change_point_summary = require("./change_point_summary");
var _empty_state = require("./empty_state");
var _significant_event_flyout = require("./significant_event_flyout");
var _significant_events_table = require("./significant_events_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamDetailSignificantEventsView({
  definition,
  refreshDefinition
}) {
  const {
    core: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState: {
      start,
      end
    }
  } = (0, _use_timefilter.useTimefilter)();
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  const xFormatter = (0, _react.useMemo)(() => {
    return (0, _charts.niceTimeFormatter)([start, end]);
  }, [start, end]);
  const significantEventsFetchState = (0, _use_fetch_significant_events.useFetchSignificantEvents)({
    name: definition.stream.name,
    start,
    end
  });
  const {
    addQuery,
    removeQuery
  } = (0, _use_significant_events_api.useSignificantEventsApi)({
    name: definition.stream.name
  }) || {};
  const [isEditFlyoutOpen, setIsEditFlyoutOpen] = (0, _react.useState)(false);
  const [queryToEdit, setQueryToEdit] = (0, _react.useState)();
  const events = (0, _react.useMemo)(() => {
    var _significantEventsFet, _significantEventsFet2;
    return (_significantEventsFet = (_significantEventsFet2 = significantEventsFetchState.value) === null || _significantEventsFet2 === void 0 ? void 0 : _significantEventsFet2.flatMap(item => {
      const change = (0, _change_point.formatChangePoint)(item);
      if (!change) {
        return [];
      }
      return [{
        id: item.query.id,
        label: /*#__PURE__*/_react.default.createElement(_change_point_summary.ChangePointSummary, {
          change: change,
          xFormatter: xFormatter
        }),
        color: theme.colors[change.color],
        time: change.time,
        header: item.query.title
      }];
    })) !== null && _significantEventsFet !== void 0 ? _significantEventsFet : [];
  }, [significantEventsFetchState.value, theme, xFormatter]);
  if (!significantEventsFetchState.value) {
    return /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, null);
  }
  const editFlyout = isEditFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_significant_event_flyout.SignificantEventFlyout, {
    onCreate: async next => {
      await (addQuery === null || addQuery === void 0 ? void 0 : addQuery(next).then(() => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.streams.significantEvents.significantEventCreateSuccessToastTitle', {
            defaultMessage: `Added significant event`
          })
        });
        setIsEditFlyoutOpen(false);
        significantEventsFetchState.refresh();
      }, error => {
        notifications.showErrorDialog({
          title: _i18n.i18n.translate('xpack.streams.significantEvents.significantEventCreateErrorToastTitle', {
            defaultMessage: `Could not add significant event`
          }),
          error
        });
      }));
    },
    onUpdate: async next => {
      await (addQuery === null || addQuery === void 0 ? void 0 : addQuery(next).then(() => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.streams.significantEvents.significantEventUpdateSuccessToastTitle', {
            defaultMessage: `Updated significant event`
          })
        });
        setIsEditFlyoutOpen(false);
        significantEventsFetchState.refresh();
      }, error => {
        notifications.showErrorDialog({
          title: _i18n.i18n.translate('xpack.streams.significantEvents.significantEventUpdateErrorToastTitle', {
            defaultMessage: `Could not update significant event`
          }),
          error
        });
      }));
    },
    onClose: () => {
      setIsEditFlyoutOpen(false);
      setQueryToEdit(undefined);
    },
    query: queryToEdit,
    name: definition.stream.name
  }) : null;
  if (significantEventsFetchState.value.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_empty_state.SignificantEventsViewEmptyState, {
      onAddClick: () => {
        setIsEditFlyoutOpen(true);
        setQueryToEdit(undefined);
      }
    }), editFlyout);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
    showQueryInput: false,
    showDatePicker: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: () => {
      setIsEditFlyoutOpen(true);
      setQueryToEdit(undefined);
    },
    iconType: "plusInCircle"
  }, _i18n.i18n.translate('xpack.streams.significantEvents.addSignificantEventButton', {
    defaultMessage: 'Add significant event query'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_timeline.Timeline, {
    start: start,
    end: end,
    events: events,
    xFormatter: xFormatter
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_significant_events_table.SignificantEventsTable, {
    definition: definition.stream,
    response: significantEventsFetchState,
    onEditClick: item => {
      setIsEditFlyoutOpen(true);
      setQueryToEdit(item.query);
    },
    onDeleteClick: async item => {
      await (removeQuery === null || removeQuery === void 0 ? void 0 : removeQuery(item.query.id).then(() => {
        significantEventsFetchState.refresh();
      }));
    },
    xFormatter: xFormatter
  }))), editFlyout);
}