"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WiredStreamDetailManagement = WiredStreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _redirect_to = require("../../redirect_to");
var _stream_detail_routing = require("../stream_detail_routing");
var _stream_detail_schema_editor = require("../stream_detail_schema_editor");
var _stream_detail_lifecycle = require("../stream_detail_lifecycle");
var _wrapper = require("./wrapper");
var _use_streams_detail_management_tabs = require("./use_streams_detail_management_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wiredStreamManagementSubTabs = ['route', 'enrich', 'schemaEditor', 'lifecycle', 'significantEvents'];
function isValidManagementSubTab(value) {
  return wiredStreamManagementSubTabs.includes(value);
}
function WiredStreamDetailManagement({
  definition,
  refreshDefinition
}) {
  const {
    path: {
      key,
      tab
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}');
  const {
    enrich,
    ...otherTabs
  } = (0, _use_streams_detail_management_tabs.useStreamsDetailManagementTabs)({
    definition,
    refreshDefinition
  });
  const tabs = {
    lifecycle: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_lifecycle.StreamDetailLifecycle, {
        definition: definition,
        refreshDefinition: refreshDefinition
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.streams.managementTab.lifecycle.tooltip', {
          defaultMessage: 'Control how long data stays in this stream. Set a custom duration or apply a shared policy.'
        })
      }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.streams.streamDetailView.lifecycleTab', {
        defaultMessage: 'Data retention'
      })))
    },
    route: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_routing.StreamDetailRouting, {
        definition: definition,
        refreshDefinition: refreshDefinition
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.routingTab', {
        defaultMessage: 'Partitioning'
      })
    },
    enrich,
    schemaEditor: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_schema_editor.StreamDetailSchemaEditor, {
        definition: definition,
        refreshDefinition: refreshDefinition
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.schemaEditorTab', {
        defaultMessage: 'Schema editor'
      })
    },
    ...otherTabs
  };
  if (!isValidManagementSubTab(tab)) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/management/{tab}",
      params: {
        path: {
          key,
          tab: 'route'
        }
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
    tabs: tabs,
    streamId: key,
    tab: tab
  });
}