"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamsDetailManagementTabs = useStreamsDetailManagementTabs;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _stream_detail_enrichment = require("../stream_detail_enrichment");
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _stream_detail_significant_events_view = require("../../stream_detail_significant_events_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStreamsDetailManagementTabs({
  definition,
  refreshDefinition
}) {
  const {
    features: {
      significantEvents
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const isSignificantEventsEnabled = !!(significantEvents !== null && significantEvents !== void 0 && significantEvents.available);
  return {
    enrich: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_enrichment.StreamDetailEnrichment, {
        definition: definition,
        refreshDefinition: refreshDefinition
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.processingTab', {
        defaultMessage: 'Processing'
      })
    },
    ...(isSignificantEventsEnabled ? {
      significantEvents: {
        content: /*#__PURE__*/_react.default.createElement(_stream_detail_significant_events_view.StreamDetailSignificantEventsView, {
          definition: definition,
          refreshDefinition: refreshDefinition
        }),
        label: _i18n.i18n.translate('xpack.streams.streamDetailView.significantEventsTab', {
          defaultMessage: 'Significant events'
        })
      }
    } : {})
  };
}