"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simulationMachine = exports.createSimulationMachineImplementations = void 0;
var _xstate = require("xstate5");
var _xstateUtils = require("@kbn/xstate-utils");
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = require("lodash");
var _objectUtils = require("@kbn/object-utils");
var _utils = require("../../utils");
var _simulation_runner_actor = require("./simulation_runner_actor");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasSamples = samples => !(0, _lodash.isEmpty)(samples);
const isValidProcessor = processor => (0, _streamsSchema.isSchema)(_streamsSchema.processorDefinitionSchema, _utils.processorConverter.toAPIDefinition(processor));
const hasValidProcessors = processors => processors.every(isValidProcessor);
const simulationMachine = exports.simulationMachine = (0, _xstate.setup)({
  types: {
    input: {},
    context: {},
    events: {}
  },
  actors: {
    runSimulation: (0, _xstateUtils.getPlaceholderFor)(_simulation_runner_actor.createSimulationRunnerActor)
  },
  actions: {
    notifySimulationRunFailure: (0, _xstateUtils.getPlaceholderFor)(_simulation_runner_actor.createSimulationRunFailureNofitier),
    storePreviewDocsFilter: (0, _xstate.assign)((_, params) => ({
      previewDocsFilter: params.filter
    })),
    storeProcessors: (0, _xstate.assign)((_, params) => ({
      processors: params.processors
    })),
    storeSamples: (0, _xstate.assign)((_, params) => ({
      samples: params.samples
    })),
    storeSimulation: (0, _xstate.assign)((_, params) => ({
      simulation: params.simulation
    })),
    storeExplicitlyEnabledPreviewColumns: (0, _xstate.assign)(({
      context
    }, params) => ({
      explicitlyEnabledPreviewColumns: params.columns,
      explicitlyDisabledPreviewColumns: context.explicitlyDisabledPreviewColumns.filter(col => !params.columns.includes(col))
    })),
    storeExplicitlyDisabledPreviewColumns: (0, _xstate.assign)(({
      context
    }, params) => ({
      explicitlyDisabledPreviewColumns: params.columns,
      explicitlyEnabledPreviewColumns: context.explicitlyEnabledPreviewColumns.filter(col => !params.columns.includes(col))
    })),
    storePreviewColumnsOrder: (0, _xstate.assign)(({
      context
    }, params) => ({
      previewColumnsOrder: params.columns
    })),
    storePreviewColumnsSorting: (0, _xstate.assign)((_, params) => ({
      previewColumnsSorting: params.sorting
    })),
    deriveDetectedSchemaFields: (0, _xstate.assign)(({
      context
    }) => ({
      detectedSchemaFields: context.simulation ? (0, _utils2.getSchemaFieldsFromSimulation)(context.simulation.detected_fields, context.detectedSchemaFields, context.streamName) : context.detectedSchemaFields
    })),
    mapField: (0, _xstate.assign)(({
      context
    }, params) => ({
      detectedSchemaFields: (0, _utils2.mapField)(context.detectedSchemaFields, params.field)
    })),
    unmapField: (0, _xstate.assign)(({
      context
    }, params) => ({
      detectedSchemaFields: (0, _utils2.unmapField)(context.detectedSchemaFields, params.fieldName)
    })),
    resetSimulationOutcome: (0, _xstate.assign)({
      processors: [],
      detectedSchemaFields: [],
      explicitlyEnabledPreviewColumns: [],
      explicitlyDisabledPreviewColumns: [],
      previewColumnsOrder: [],
      simulation: undefined,
      previewDocsFilter: 'outcome_filter_all'
    }),
    resetProcessors: (0, _xstate.assign)({
      processors: []
    }),
    resetSamples: (0, _xstate.assign)({
      samples: []
    })
  },
  delays: {
    processorChangeDebounceTime: 800
  },
  guards: {
    canSimulate: ({
      context
    }) => hasSamples(context.samples) && hasValidProcessors(context.processors),
    hasProcessors: (_, params) => !(0, _lodash.isEmpty)(params.processors),
    '!hasSamples': (_, params) => !hasSamples(params.samples)
  }
}).createMachine({
  /** @xstate-layout N4IgpgJg5mDOIC5SwJYFsCuAbAhgFxQHsA7AYlU1wJIDoBjACx2JgAUAnMANxTAHcAIoTqwAYiix4w7ANoAGALqJQAB0KpqxZSAAeiAGwBmOTQDsAJnP65AFnMAOAIw2598wBoQAT0SOArFY09vqmjmGGNvZy+vY2AL5xnhTY+ERkyVRpNJywYHjySkggahpp2noIALSWNEYAnHX2fnX6djHRNp4+CI76zjRycobNFo729sOmCUnoKZrks5m0nHRgKFxgAPqwOGgqWHAF2iUomuWI1ea1hg1NLW1RrV2+poamNC6N5n5+hs4u8USIAyqRIC0ooOI2TAq3WWx2ewOsBkjkKqnUpzKRQqfhs7zq5j+hn0dUihkM5kczwQrT8NEsch++gC9xsfmmwMWkPBcyyKzWG22u32h3MaOKGLO2IuNXqjWarSsj063l8wRMTmsv1iAICHJB8xU7GEcFghHYsBoACojkUTlLQBVLtdbgqHh1qc5KQM6q9hrZzHi7PquYbjatYGb2PRmKssLb0aUSOcqrKbvL7kqPaqen5HO8frY-NFHHI6sNDCGIWGTZHzfQmCwwAmJUmtNKqnZHEFTAFHFZGhEbL7qTZ+pZ9MzYsFxvpzFXeWCjbWozQIGADlIW-asY6LjcbDRjKXeuY6qWKXVqbT6eZGYr7HVi8GgQa0qRlxHV+vN83UcdJV3XQZSuOU7kVdonhzRwn3eAd-EMR9zFMYJ9AXJYoRQCADh5DCaAAM14LAIEtNAcBUbdAOTDtBwGQkbGJQkjG+a8JmuRlA0aYcbnsdDIRoLCcLfWhCI3EiaAwYgyIoxQALbFNaLkejGOJCk-GpFCTFcYl7FCfsfgaPjNDXMAACNCEkugUBYABhRsYFgUgdFgPB8DAGgcHwqR2AACk-U1zTs5gYAEMyLOIVYABV0DAABKXD+PXczLOsqAgqbZFZLtKj2z3BBFOUudVJY6CbneG5GV6Nw3jeKZX1DLIcEjaQCBYAAlMAAEcMBQTg0DAYg8Ecyj5I7UsGnpCJkMiX0YLnT1-HeGJTBsGwjCGH5AyMxrmvYVqoA67rerAfrBuG-9stGvKwjCGgfjW4YGKUlDDGvN52NxRDkIJX1tuWSTiFSgBlBqwQgEh3OsrhCAAa3c4TiDagHpAAQToPBzRGzFqLy4d7BoMYVvLZDhhHHN7jMJw7y9AldLqP6oXYAHgdBshpGNaN9nwfDzTQGgEaR4hiFR9HMayxNsdy4CEDxgndO4kmRmpXTuwpR4KUGUlCQSIFiEIdd4CKBG5MllNKjWuoez7AcJlWsnunzcqLFGKx82sAkGYE7CwBNh1paMfG5DGVxTDqaIzz+akrEPXTkOD30-GZJ9PaS8KrNs+y4F9oCKiKmgw4JSdVv8RxhmpAI6WZIY7HJL6+k9prcj21LDp6vqBqG7Ocel893jkImmn7sc8XscviXz5xGVMUwy0QtlPaZoWWerICd27iown0AZcRJBik7ZUecyQj4z2YomZ7LHW4iAA */
  id: 'simulation',
  context: ({
    input
  }) => ({
    detectedSchemaFields: [],
    previewDocsFilter: 'outcome_filter_all',
    previewDocuments: [],
    explicitlyDisabledPreviewColumns: [],
    explicitlyEnabledPreviewColumns: [],
    previewColumnsOrder: [],
    previewColumnsSorting: {
      fieldName: undefined,
      direction: 'asc'
    },
    processors: input.processors,
    samples: [],
    streamName: input.streamName
  }),
  initial: 'idle',
  on: {
    'simulation.changePreviewDocsFilter': {
      actions: [{
        type: 'storePreviewDocsFilter',
        params: ({
          event
        }) => event
      }]
    },
    'simulation.reset': {
      target: '.idle',
      actions: [{
        type: 'resetSimulationOutcome'
      }, {
        type: 'resetProcessors'
      }]
    },
    'simulation.receive_samples': [{
      guard: {
        type: '!hasSamples',
        params: ({
          event
        }) => event
      },
      target: '.idle',
      actions: [{
        type: 'resetSimulationOutcome'
      }, {
        type: 'resetSamples'
      }]
    }, {
      guard: {
        type: 'hasProcessors',
        params: ({
          context
        }) => ({
          processors: context.processors
        })
      },
      target: '.assertingRequirements',
      actions: [{
        type: 'storeSamples',
        params: ({
          event
        }) => event
      }]
    }, {
      target: '.idle',
      actions: [{
        type: 'storeSamples',
        params: ({
          event
        }) => event
      }]
    }],
    'previewColumns.updateExplicitlyEnabledColumns': {
      actions: [{
        type: 'storeExplicitlyEnabledPreviewColumns',
        params: ({
          event
        }) => event
      }],
      target: '.idle'
    },
    'previewColumns.updateExplicitlyDisabledColumns': {
      actions: [{
        type: 'storeExplicitlyDisabledPreviewColumns',
        params: ({
          event
        }) => event
      }],
      target: '.idle'
    },
    'previewColumns.order': {
      actions: [{
        type: 'storePreviewColumnsOrder',
        params: ({
          event
        }) => event
      }],
      target: '.idle'
    },
    'previewColumns.setSorting': {
      actions: [{
        type: 'storePreviewColumnsSorting',
        params: ({
          event
        }) => event
      }],
      target: '.idle'
    },
    // Handle adding/reordering processors
    'processors.*': {
      target: '.assertingRequirements',
      actions: [{
        type: 'storeProcessors',
        params: ({
          event
        }) => event
      }]
    },
    'processor.cancel': {
      target: '.assertingRequirements',
      actions: [{
        type: 'storeProcessors',
        params: ({
          event
        }) => event
      }]
    },
    'processor.change': {
      target: '.debouncingChanges',
      reenter: true,
      description: 'Re-enter debouncing state and reinitialize the delayed processing.',
      actions: [{
        type: 'storeProcessors',
        params: ({
          event
        }) => event
      }]
    },
    'processor.delete': [{
      guard: {
        type: 'hasProcessors',
        params: ({
          event
        }) => ({
          processors: event.processors
        })
      },
      target: '.assertingRequirements',
      actions: [{
        type: 'storeProcessors',
        params: ({
          event
        }) => event
      }]
    }, {
      target: '.idle',
      actions: [{
        type: 'resetSimulationOutcome'
      }, {
        type: 'resetProcessors'
      }]
    }]
  },
  states: {
    idle: {
      on: {
        'simulation.fields.map': {
          target: 'assertingRequirements',
          actions: [{
            type: 'mapField',
            params: ({
              event
            }) => event
          }]
        },
        'simulation.fields.unmap': {
          target: 'assertingRequirements',
          actions: [{
            type: 'unmapField',
            params: ({
              event
            }) => event
          }]
        }
      }
    },
    debouncingChanges: {
      after: {
        processorChangeDebounceTime: 'assertingRequirements'
      }
    },
    assertingRequirements: {
      always: [{
        guard: 'canSimulate',
        target: 'runningSimulation'
      }, {
        target: 'idle'
      }]
    },
    runningSimulation: {
      invoke: {
        id: 'simulationRunnerActor',
        src: 'runSimulation',
        input: ({
          context
        }) => ({
          streamName: context.streamName,
          documents: context.samples.map(_objectUtils.flattenObjectNestedLast),
          processors: context.processors,
          detectedFields: context.detectedSchemaFields
        }),
        onDone: {
          target: 'idle',
          actions: [{
            type: 'storeSimulation',
            params: ({
              event
            }) => ({
              simulation: event.output
            })
          }, {
            type: 'deriveDetectedSchemaFields'
          }]
        },
        onError: {
          target: 'idle',
          actions: [{
            type: 'notifySimulationRunFailure'
          }]
        }
      }
    }
  }
});
const createSimulationMachineImplementations = ({
  streamsRepositoryClient,
  toasts
}) => ({
  actors: {
    runSimulation: (0, _simulation_runner_actor.createSimulationRunnerActor)({
      streamsRepositoryClient
    })
  },
  actions: {
    notifySimulationRunFailure: (0, _simulation_runner_actor.createSimulationRunFailureNofitier)({
      toasts
    })
  }
});
exports.createSimulationMachineImplementations = createSimulationMachineImplementations;