"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailEnrichmentContent = StreamDetailEnrichmentContent;
exports.StreamDetailEnrichmentContentImpl = StreamDetailEnrichmentContentImpl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _kbn_url_state_context = require("../../../util/kbn_url_state_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _processors_list = require("./processors_list");
var _sortable_list = require("./sortable_list");
var _management_bottom_bar = require("../management_bottom_bar");
var _processors = require("./processors");
var _simulation_playground = require("./simulation_playground");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MemoSimulationPlayground = /*#__PURE__*/_react.default.memo(_simulation_playground.SimulationPlayground);
function StreamDetailEnrichmentContent(props) {
  const {
    core,
    dependencies
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    streams: {
      streamsRepositoryClient
    }
  } = dependencies.start;
  const urlStateStorageContainer = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  return /*#__PURE__*/_react.default.createElement(_stream_enrichment_state_machine.StreamEnrichmentContextProvider, {
    definition: props.definition,
    refreshDefinition: props.refreshDefinition,
    core: core,
    data: data,
    streamsRepositoryClient: streamsRepositoryClient,
    urlStateStorageContainer: urlStateStorageContainer
  }, /*#__PURE__*/_react.default.createElement(StreamDetailEnrichmentContentImpl, null));
}
function StreamDetailEnrichmentContentImpl() {
  const {
    appParams,
    core
  } = (0, _use_kibana.useKibana)();
  const {
    resetChanges,
    saveChanges
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const isReady = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches('ready'));
  const hasChanges = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.can({
    type: 'stream.update'
  }));
  const canManage = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.definition.privileges.manage);
  const isSavingChanges = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      stream: 'updating'
    }
  }));
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: hasChanges,
    history: appParams.history,
    http: core.http,
    navigateToUrl: core.application.navigateToUrl,
    openConfirm: core.overlays.openConfirm,
    shouldPromptOnReplace: false
  });
  if (!isReady) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: (0, _react2.css)`
          display: flex;
          overflow: hidden auto;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, null, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 40,
    minSize: "480px",
    tabIndex: 0,
    paddingSize: "none",
    css: verticalFlexCss
  }, /*#__PURE__*/_react.default.createElement(ProcessorsEditor, null)), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    indicator: "border",
    accountForScrollbars: "both"
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 60,
    minSize: "300px",
    tabIndex: 0,
    paddingSize: "s",
    css: verticalFlexCss
  }, /*#__PURE__*/_react.default.createElement(MemoSimulationPlayground, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_management_bottom_bar.ManagementBottomBar, {
    onCancel: resetChanges,
    onConfirm: saveChanges,
    isLoading: isSavingChanges,
    disabled: !hasChanges,
    insufficientPrivileges: !canManage
  })));
}
const ProcessorsEditor = /*#__PURE__*/_react.default.memo(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    reorderProcessors
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const definition = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.definition);
  const processorsRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.processorsRefs.filter(processorRef => processorRef.getSnapshot().matches('configured')));
  const simulation = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => snapshot.context.simulation);
  const errors = (0, _react.useMemo)(() => {
    if (!simulation) {
      return {
        ignoredFields: [],
        mappingFailures: []
      };
    }
    const ignoredFieldsSet = new Set();
    const mappingFailuresSet = new Set();
    simulation.documents.forEach(doc => {
      doc.errors.forEach(error => {
        if (error.type === 'ignored_fields_failure') {
          error.ignored_fields.forEach(ignored => {
            ignoredFieldsSet.add(ignored.field);
          });
        }
        if (error.type === 'field_mapping_failure' && mappingFailuresSet.size < 2) {
          mappingFailuresSet.add(error.message);
        }
      });
    });
    return {
      ignoredFields: Array.from(ignoredFieldsSet),
      mappingFailures: Array.from(mappingFailuresSet)
    };
  }, [simulation]);
  const handlerItemDrag = ({
    source,
    destination
  }) => {
    if (source && destination) {
      const items = (0, _eui.euiDragDropReorder)(processorsRefs, source.index, destination.index);
      reorderProcessors(items);
    }
  };
  const hasProcessors = !(0, _lodash.isEmpty)(processorsRefs);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    borderRadius: "none",
    grow: false,
    css: (0, _react2.css)`
          border-bottom: ${euiTheme.border.thin};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.headingTitle', {
    defaultMessage: 'Processors for field extraction'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    size: "xs"
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.headingSubtitle', {
    defaultMessage: 'Drag and drop existing processors to update their execution order.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    borderRadius: "none",
    css: (0, _react2.css)`
          overflow: auto;
        `
  }, hasProcessors && /*#__PURE__*/_react.default.createElement(_sortable_list.SortableList, {
    onDragItem: handlerItemDrag
  }, processorsRefs.map((processorRef, idx) => /*#__PURE__*/_react.default.createElement(_processors_list.DraggableProcessorListItem, {
    disableDrag: !definition.privileges.simulate,
    key: processorRef.id,
    idx: idx,
    processorRef: processorRef,
    processorMetrics: simulation === null || simulation === void 0 ? void 0 : simulation.processors_metrics[processorRef.id]
  }))), definition.privileges.simulate && /*#__PURE__*/_react.default.createElement(_processors.AddProcessorPanel, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    grow: false
  }, !(0, _lodash.isEmpty)(errors.ignoredFields) && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    grow: false,
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "ignored-fields-failures-accordion",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ignoredFieldsFailure.title', {
      defaultMessage: 'Some fields were ignored during the simulation.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ignoredFieldsFailure.description', {
    defaultMessage: 'Some fields in these documents were ignored during the ingestion simulation. Review the fields’ mapping limits.'
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.ignoredFieldsFailure.fieldsList",
    defaultMessage: "The ignored fields are: {fields}",
    values: {
      fields: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        css: (0, _react2.css)`
                            margin-top: ${euiTheme.size.s};
                          `
      }, errors.ignoredFields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, field)))
    }
  }))))), !(0, _lodash.isEmpty)(errors.mappingFailures) && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    grow: false,
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "mapping-failures-accordion",
    initialIsOpen: true,
    buttonContent: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.fieldMappingsFailure.title', {
      defaultMessage: 'Field conflicts during simulation'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.fieldMappingsFailure.fieldsList",
    defaultMessage: "These are some mapping failures that occurred during the simulation:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, errors.mappingFailures.map((failureMessage, id) => /*#__PURE__*/_react.default.createElement("li", {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: clampTwoLines,
    size: "s"
  }, failureMessage)))))))));
});
const verticalFlexCss = (0, _react2.css)`
  display: flex;
  flex-direction: column;
`;
const clampTwoLines = (0, _react2.css)`
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
  text-overflow: ellipsis;
`;