"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnpromoteFieldModal = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnpromoteFieldModal = ({
  field,
  onClose,
  onFieldUnmap
}) => {
  const [{
    loading
  }, unmapField] = (0, _useAsyncFn.default)(async () => {
    await onFieldUnmap(field.name);
    if (onClose) onClose();
  }, [field, onClose, onFieldUnmap]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    isLoading: loading,
    title: field.name,
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onClose,
    onConfirm: unmapField,
    cancelButtonText: _i18n.i18n.translate('xpack.streams.unpromoteFieldModal.unpromoteFieldButtonCancelLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.streams.unpromoteFieldModal.unpromoteFieldButtonLabel', {
      defaultMessage: 'Unmap field'
    }),
    buttonColor: "danger"
  }, _i18n.i18n.translate('xpack.streams.unpromoteFieldModal.unpromoteFieldWarning', {
    defaultMessage: 'Are you sure you want to unmap this field from template mappings?'
  }));
};
exports.UnpromoteFieldModal = UnpromoteFieldModal;