"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsTable = FieldsTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _constants = require("./constants");
var _field_actions = require("./field_actions");
var _field_parent = require("./field_parent");
var _field_status = require("./field_status");
var _field_type = require("./field_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldsTable({
  isLoading,
  controls,
  defaultColumns,
  fields,
  stream,
  withTableActions,
  withToolbar
}) {
  // Column visibility
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(defaultColumns);
  // Column sorting
  const [sortingColumns, setSortingColumns] = (0, _react.useState)([]);
  const filteredFields = (0, _react.useMemo)(() => filterFieldsByControls(fields, controls), [fields, controls]);
  const trailingColumns = (0, _react.useMemo)(() => {
    if (!withTableActions) return undefined;
    return [createFieldActionsCellRenderer(filteredFields)];
  }, [withTableActions, filteredFields]);
  const RenderCellValue = (0, _react.useMemo)(() => createCellRenderer(filteredFields, stream), [filteredFields, stream]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "data-test-subj": isLoading ? 'streamsAppSchemaEditorFieldsTableLoading' : 'streamsAppSchemaEditorFieldsTableLoaded',
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.fieldsTable.actionsTitle', {
      defaultMessage: 'Preview'
    }),
    columns: Object.entries(_constants.TABLE_COLUMNS).map(([columnId, value]) => ({
      id: columnId,
      ...value
    })),
    columnVisibility: {
      visibleColumns,
      setVisibleColumns,
      canDragAndDropColumns: false
    },
    sorting: {
      columns: sortingColumns,
      onSort: setSortingColumns
    },
    toolbarVisibility: withToolbar,
    rowCount: filteredFields.length,
    renderCellValue: RenderCellValue,
    trailingControlColumns: trailingColumns,
    gridStyle: {
      border: 'none',
      rowHover: 'none',
      header: 'underline'
    },
    inMemory: {
      level: 'sorting'
    }
  });
}
const createCellRenderer = (fields, stream) => ({
  rowIndex,
  columnId
}) => {
  const field = fields[rowIndex];
  if (!field) return null;
  const {
    parent,
    status
  } = field;
  if (columnId === 'type') {
    if (!field.type) {
      if (field.status === 'unmapped' && field.esType) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "xs",
          responsive: false
        }, field.esType, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableTypeEsTypeTooltip', {
            defaultMessage: 'This field is not managed by Streams, but is defined in Elasticsearch. It can be controlled via the underlying index template and component templates available in the "Advanced" tab.'
          }),
          position: "right"
        }));
      }
      return _constants.EMPTY_CONTENT;
    }
    return /*#__PURE__*/_react.default.createElement(_field_type.FieldType, {
      type: field.type,
      aliasFor: field.alias_for
    });
  }
  if (columnId === 'parent') {
    return /*#__PURE__*/_react.default.createElement(_field_parent.FieldParent, {
      parent: parent,
      linkEnabled: field.parent !== stream.name
    });
  }
  if (columnId === 'status') {
    return /*#__PURE__*/_react.default.createElement(_field_status.FieldStatusBadge, {
      status: status
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, field[columnId] || _constants.EMPTY_CONTENT);
};
const createFieldActionsCellRenderer = fields => ({
  id: 'field-actions',
  width: 40,
  headerCellRender: () => /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableActionsTitle', {
    defaultMessage: 'Field actions'
  }))),
  rowCellRender: ({
    rowIndex
  }) => {
    const field = fields[rowIndex];
    if (!field) return null;
    return /*#__PURE__*/_react.default.createElement(_field_actions.FieldActionsCell, {
      field: field
    });
  }
});
const filterFieldsByControls = (fields, controls) => {
  if (!controls.query && (0, _lodash.isEmpty)(controls.type) && (0, _lodash.isEmpty)(controls.status)) {
    return fields;
  }
  const matchingQueryFields = _eui.EuiSearchBar.Query.execute(controls.query, fields, {
    defaultFields: ['name', 'type']
  });
  const filteredByGroupsFields = matchingQueryFields.filter(field => {
    return ((0, _lodash.isEmpty)(controls.type) || field.type && controls.type.includes(field.type)) && (
    // Filter by applied type
    (0, _lodash.isEmpty)(controls.status) || controls.status.includes(field.status)) // Filter by applied status
    ;
  });
  return filteredByGroupsFields;
};