"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUMMARY_REQUIRED = exports.OPTIONAL_LABEL = exports.INTEGRATION_KEY_REQUIRED = exports.INTEGRATION_KEY_LABEL = exports.DEDUP_KEY_REQUIRED = exports.API_URL_LABEL = exports.API_URL_INVALID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_REQUIRED = exports.SUMMARY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.requiredSummaryText', {
  defaultMessage: 'Summary is required.'
});
const DEDUP_KEY_REQUIRED = exports.DEDUP_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.requiredDedupKeyText', {
  defaultMessage: 'DedupKey is required when resolving or acknowledging an incident.'
});
const INTEGRATION_KEY_REQUIRED = exports.INTEGRATION_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.error.requiredRoutingKeyText', {
  defaultMessage: 'An integration key / routing key is required.'
});
const API_URL_LABEL = exports.API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.apiUrlTextFieldLabel', {
  defaultMessage: 'API URL'
});
const API_URL_INVALID = exports.API_URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.apiUrlInvalid', {
  defaultMessage: 'Invalid API URL'
});
const INTEGRATION_KEY_LABEL = exports.INTEGRATION_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.routingKeyTextFieldLabel', {
  defaultMessage: 'Integration key'
});
const OPTIONAL_LABEL = exports.OPTIONAL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.optionalLabel', {
  defaultMessage: 'Optional'
});