"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emailServices = void 0;
exports.getConnectorType = getConnectorType;
exports.getEmailServices = getEmailServices;
var _lodash = require("lodash");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/actions-plugin/common");
var _constants = require("../../../common/email/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const emailServices = exports.emailServices = [{
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.gmailServerTypeLabel', {
    defaultMessage: 'Gmail'
  }),
  value: 'gmail',
  ['kbn-setting-value']: _constants.serviceParamValueToKbnSettingMap.gmail
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.outlookServerTypeLabel', {
    defaultMessage: 'Outlook'
  }),
  value: 'outlook365',
  ['kbn-setting-value']: _constants.serviceParamValueToKbnSettingMap.outlook365
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.amazonSesServerTypeLabel', {
    defaultMessage: 'Amazon SES'
  }),
  value: 'ses',
  ['kbn-setting-value']: _constants.serviceParamValueToKbnSettingMap.ses
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.elasticCloudServerTypeLabel', {
    defaultMessage: 'Elastic Cloud'
  }),
  value: 'elastic_cloud',
  ['kbn-setting-value']: _constants.serviceParamValueToKbnSettingMap.elastic_cloud
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.exchangeServerTypeLabel', {
    defaultMessage: 'MS Exchange Server'
  }),
  value: 'exchange_server',
  ['kbn-setting-value']: _constants.serviceParamValueToKbnSettingMap.exchange_server
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.otherServerTypeLabel', {
    defaultMessage: 'Other'
  }),
  value: 'other',
  ['kbn-setting-value']: _constants.serviceParamValueToKbnSettingMap.other
}];

// Return the current service regardless of its enabled state to allow users to:
// 1. View the current service in the dropdown UI
// 2. Update the service configuration if needed
// Note: The connector update endpoint will reject updates where the service
// remains unchanged but is disabled.
function getEmailServices(isCloudEnabled, enabledEmailsServices, currentService) {
  const allEmailServices = isCloudEnabled ? emailServices : emailServices.filter(service => service.value !== 'elastic_cloud');
  if (enabledEmailsServices.includes('*')) {
    return allEmailServices;
  }
  return allEmailServices.filter(service => service.value === currentService || enabledEmailsServices.includes(service['kbn-setting-value']));
}
function getConnectorType(services) {
  return {
    id: '.email',
    iconClass: 'email',
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.email.selectMessageText', {
      defaultMessage: 'Send email from your server.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.email.connectorTypeTitle', {
      defaultMessage: 'Send to email'
    }),
    validateParams: async actionParams => {
      var _actionParams$message, _actionParams$subject;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        to: new Array(),
        cc: new Array(),
        bcc: new Array(),
        message: new Array(),
        subject: new Array()
      };
      const validationResult = {
        errors
      };
      if (!((_actionParams$message = actionParams.message) !== null && _actionParams$message !== void 0 && _actionParams$message.length)) {
        errors.message.push(translations.MESSAGE_REQUIRED);
      }
      if (!((_actionParams$subject = actionParams.subject) !== null && _actionParams$subject !== void 0 && _actionParams$subject.length)) {
        errors.subject.push(translations.SUBJECT_REQUIRED);
      }
      const toEmails = getToFields(actionParams);
      const ccEmails = getCcFields(actionParams);
      const bccEmails = getBccFields(actionParams);
      if (toEmails.length === 0 && ccEmails.length === 0 && bccEmails.length === 0) {
        const errorText = translations.TO_CC_REQUIRED;
        errors.to.push(errorText);
        errors.cc.push(errorText);
        errors.bcc.push(errorText);
      }
      const allEmails = (0, _lodash.uniq)(toEmails.concat(ccEmails).concat(bccEmails));
      const validatedEmails = services.validateEmailAddresses(allEmails, {
        treatMustacheTemplatesAsValid: true
      });
      const toEmailSet = new Set(toEmails);
      const ccEmailSet = new Set(ccEmails);
      const bccEmailSet = new Set(bccEmails);
      for (const validated of validatedEmails) {
        if (!validated.valid) {
          const email = validated.address;
          const message = validated.reason === _common.InvalidEmailReason.notAllowed ? translations.getNotAllowedEmailAddress(email) : translations.getInvalidEmailAddress(email);
          if (toEmailSet.has(email)) errors.to.push(message);
          if (ccEmailSet.has(email)) errors.cc.push(message);
          if (bccEmailSet.has(email)) errors.bcc.push(message);
        }
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./email_connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./email_params'))))
  };
}
function getToFields(actionParams) {
  if (!(actionParams.to instanceof Array)) return [];
  return actionParams.to;
}
function getCcFields(actionParams) {
  if (!(actionParams.cc instanceof Array)) return [];
  return actionParams.cc;
}
function getBccFields(actionParams) {
  if (!(actionParams.bcc instanceof Array)) return [];
  return actionParams.bcc;
}