"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesDescription = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _manage_spaces_button = require("./manage_spaces_button");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpacesDescription = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const panelProps = {
    id: props.id,
    css: (0, _react.css)`
      max-width: calc(${euiTheme.size.l} * 10);
    `,
    title: 'Spaces'
  };
  const spacesLoadingMessage = _i18n.i18n.translate('xpack.spaces.navControl.loadingMessage', {
    defaultMessage: 'Loading...'
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, panelProps, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
          padding: ${euiTheme.size.m};
        `
  }, /*#__PURE__*/_react2.default.createElement("p", null, props.isLoading ? spacesLoadingMessage : (0, _constants.getSpacesFeatureDescription)())), /*#__PURE__*/_react2.default.createElement("div", {
    key: "manageSpacesButton",
    css: (0, _react.css)`
          padding: ${euiTheme.size.m};
        `
  }, /*#__PURE__*/_react2.default.createElement(_manage_spaces_button.ManageSpacesButton, {
    size: "s",
    fullWidth: true,
    onClick: props.onClickManageSpaceBtn,
    capabilities: props.capabilities,
    navigateToApp: props.navigateToApp
  })));
};
exports.SpacesDescription = SpacesDescription;