"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRunTimeFieldBeingUsed = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isFieldBeingUsed = (fieldName, query) => {
  if (!query) {
    return false;
  }
  const checkKql = kql => {
    const queryStr = kql.replace(/\s{2,}/g, ' ').trim();
    return queryStr.includes(`${fieldName} :`) || queryStr.includes(`${fieldName}:`);
  };
  if (typeof query === 'string') {
    return checkKql(query);
  } else {
    const kql = query.kqlQuery;
    const inKql = kql && checkKql(kql);
    const inFilter = query.filters && query.filters.some(filter => {
      return filter.meta.field === fieldName || filter.meta.key === fieldName;
    });
    return inKql || inFilter;
  }
};
const useRunTimeFieldBeingUsed = (name, dataView) => {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const value = watch(name);
  if (!dataView || !value) {
    return [];
  }
  const runTimeMappings = dataView.getRuntimeMappings();
  const filter = _sloSchema.querySchema.is(value) ? value : undefined;
  const fieldNames = Object.keys(runTimeMappings).filter(key => {
    return isFieldBeingUsed(key, filter);
  });
  return fieldNames !== null && fieldNames !== void 0 ? fieldNames : [];
};
exports.useRunTimeFieldBeingUsed = useRunTimeFieldBeingUsed;