"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricIndicator = MetricIndicator;
exports.NEW_TIMESLICE_METRIC = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _query_builder = require("../../common/query_builder");
var _constants = require("../../../constants");
var _metric_input = require("./metric_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_TIMESLICE_METRIC = exports.NEW_TIMESLICE_METRIC = {
  name: 'A',
  aggregation: 'avg',
  field: ''
};
const MAX_VARIABLES = 26;
const CHAR_CODE_FOR_A = 65;
const CHAR_CODE_FOR_Z = CHAR_CODE_FOR_A + MAX_VARIABLES;
const VAR_NAMES = (0, _lodash.range)(CHAR_CODE_FOR_A, CHAR_CODE_FOR_Z).map(c => String.fromCharCode(c));
const INVALID_EQUATION_REGEX = /[^A-Z|+|\-|\s|\d+|\.|\(|\)|\/|\*|>|<|=|\?|\:|&|\!|\|]+/;
const validateEquation = value => {
  const result = value.match(INVALID_EQUATION_REGEX);
  return result === null;
};
function createEquationFromMetric(names) {
  return names.join(' + ');
}
const equationLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.equationLabel', {
  defaultMessage: 'Equation'
});
const equationTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.totalEquation.tooltip', {
    defaultMessage: 'This supports basic math (A + B / C) and boolean logic (A < B ? A : B).'
  }),
  position: "top"
});
const thresholdLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.thresholdLabel', {
  defaultMessage: 'Threshold'
});
const thresholdTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.threshold.tooltip', {
    defaultMessage: 'This value combined with the comparator will determine if the slice is "good" or "bad".'
  }),
  position: "top"
});
function MetricIndicator({
  indexFields,
  isLoadingIndex,
  dataView
}) {
  const {
    control,
    watch,
    setValue,
    register,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const {
    fields,
    append,
    remove
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: `indicator.params.metric.metrics`
  });
  const equation = watch(`indicator.params.metric.equation`);
  const indexPattern = watch('indicator.params.index');
  const disableAdd = (fields === null || fields === void 0 ? void 0 : fields.length) === MAX_VARIABLES || !indexPattern;
  const disableDelete = (fields === null || fields === void 0 ? void 0 : fields.length) === 1 || !indexPattern;
  const setDefaultEquationIfUnchanged = (previousNames, nextNames) => {
    const defaultEquation = createEquationFromMetric(previousNames);
    if (defaultEquation === equation) {
      setValue(`indicator.params.metric.equation`, createEquationFromMetric(nextNames));
    }
  };
  const handleDeleteMetric = index => () => {
    var _fields$map;
    const currentVars = (_fields$map = fields.map(m => m.name)) !== null && _fields$map !== void 0 ? _fields$map : ['A'];
    const deletedVar = currentVars[index];
    setDefaultEquationIfUnchanged(currentVars, (0, _lodash.xor)(currentVars, [deletedVar]));
    remove(index);
  };
  const handleAddMetric = () => {
    var _fields$map2;
    const currentVars = (_fields$map2 = fields.map(m => m.name)) !== null && _fields$map2 !== void 0 ? _fields$map2 : ['A'];
    const name = (0, _lodash.first)((0, _lodash.xor)(VAR_NAMES, currentVars));
    setDefaultEquationIfUnchanged(currentVars, [...currentVars, name]);
    append({
      ...NEW_TIMESLICE_METRIC,
      name
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, fields === null || fields === void 0 ? void 0 : fields.map((metric, index, arr) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: metric.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
    hidden: true
  }, register(`indicator.params.metric.metrics.${index}.name`))), /*#__PURE__*/_react.default.createElement(_metric_input.MetricInput, {
    isLoadingIndex: isLoadingIndex,
    metricIndex: index,
    indexPattern: indexPattern,
    indexFields: indexFields
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "o11yMetricIndicatorButton",
    iconType: "trash",
    color: "danger",
    style: {
      marginTop: '1.5em'
    },
    onClick: handleDeleteMetric(index),
    disabled: disableDelete,
    title: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.deleteLabel', {
      defaultMessage: 'Delete metric'
    }),
    "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.deleteLabel', {
      defaultMessage: 'Delete metric'
    })
  }))), /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "timesliceMetricIndicatorFormMetricQueryInput",
    dataView: dataView,
    label: `${filterLabel} ${metric.name}`,
    name: `indicator.params.metric.metrics.${index}.filter`,
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.goodQuery.placeholder', {
      defaultMessage: 'KQL filter'
    }),
    required: false,
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.goodQuery.tooltip', {
        defaultMessage: 'This KQL query should return a subset of events.'
      }),
      position: "top"
    })
  })), index !== arr.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "quarter"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "timesliceMetricIndicatorAddMetricButton",
    color: 'primary',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: handleAddMetric,
    isDisabled: disableAdd,
    "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.addMetricAriaLabel', {
      defaultMessage: 'Add metric'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.timesliceMetric.addMetricLabel",
    defaultMessage: "Add metric"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.metric.equation`,
    defaultValue: "",
    rules: {
      required: true,
      validate: {
        validateEquation
      }
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement("span", null, equationLabel, " ", equationTooltip),
      isInvalid: fieldState.invalid,
      error: [_i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.equation.invalidCharacters', {
        defaultMessage: 'The equation field only supports the following characters: A-Z, +, -, /, *, (, ), ?, !, &, :, |, >, <, ='
      })]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
      isInvalid: fieldState.invalid,
      disabled: !indexPattern,
      fullWidth: true,
      value: field.value,
      "data-test-subj": "timesliceMetricEquation",
      onChange: event => field.onChange(event.target.value)
    })))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.metric.comparator`,
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      isInvalid: fieldState.invalid,
      label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.comparatorLabel', {
        defaultMessage: 'Comparator'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      isInvalid: fieldState.invalid
    }, field, {
      "data-test-subj": "timesliceMetricComparatorSelection",
      disabled: !indexPattern,
      value: field.value,
      options: _constants.COMPARATOR_OPTIONS,
      onChange: event => field.onChange(event.target.value)
    })))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: getFieldState('indicator.params.metric.threshold').invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, thresholdLabel, " ", thresholdTooltip)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: 'indicator.params.metric.threshold',
    control: control,
    rules: {
      required: true
    },
    defaultValue: 0,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      "data-test-subj": "timesliceMetricThreshold",
      required: true,
      isInvalid: fieldState.invalid,
      value: String(field.value),
      style: {
        width: 80
      },
      disabled: !indexPattern,
      onChange: event => field.onChange(Number(event.target.value))
    }))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.equationHelpText', {
    defaultMessage: 'Supports basic math equations, valid charaters are: A-Z, +, -, /, *, (, ), ?, !, &, :, |, >, <, ='
  }))))));
}
const filterLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.filterLabel', {
  defaultMessage: 'Filter'
});