"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelector = FieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_apm_suggestions = require("../../../../../hooks/use_fetch_apm_suggestions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldSelector({
  dataTestSubj,
  fieldName,
  label,
  name,
  placeholder,
  tooltip
}) {
  const {
    control,
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const serviceName = watch('indicator.params.service');
  const [search, setSearch] = (0, _react.useState)('');
  const {
    suggestions,
    isLoading
  } = (0, _use_fetch_apm_suggestions.useFetchApmSuggestions)({
    fieldName,
    search,
    serviceName
  });
  const debouncedSearch = (0, _lodash.debounce)(value => setSearch(value), 200);
  const options = [{
    value: _sloSchema.ALL_VALUE,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.fieldSelector.all', {
      defaultMessage: 'All'
    })
  }].concat(createOptions(suggestions));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: !!tooltip ? /*#__PURE__*/_react.default.createElement("span", null, label, " ", tooltip) : label,
    isInvalid: getFieldState(name).invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: name,
    control: control,
    rules: {
      required: true
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      "aria-label": placeholder,
      async: true,
      "data-test-subj": dataTestSubj,
      isClearable: true,
      isInvalid: fieldState.invalid,
      isLoading: isLoading,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      onSearchChange: value => debouncedSearch(value),
      options: options,
      placeholder: placeholder,
      selectedOptions: !!field.value && typeof field.value === 'string' ? [{
        value: field.value,
        label: field.value,
        'data-test-subj': `${dataTestSubj}SelectedValue`
      }] : [],
      singleSelection: true
    }))
  })));
}
function createOptions(suggestions) {
  return suggestions.map(suggestion => ({
    label: suggestion,
    value: suggestion
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}