"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricTimesliceAnnotation = MetricTimesliceAnnotation;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../slo_edit/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetricTimesliceAnnotation({
  slo,
  maxValue,
  minValue
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (slo.indicator.type !== 'sli.metric.timeslice') {
    return null;
  }
  const threshold = slo.indicator.params.metric.threshold;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "thresholdAnnotation",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: threshold
    }],
    style: {
      line: {
        strokeWidth: 2,
        stroke: euiTheme.colors.warning,
        opacity: 1
      }
    },
    marker: /*#__PURE__*/_react.default.createElement("span", null, threshold),
    markerPosition: "right"
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: [{
      coordinates: ['GT', 'GTE'].includes(slo.indicator.params.metric.comparator) ? {
        y0: threshold,
        y1: maxValue
      } : {
        y0: minValue,
        y1: threshold
      },
      details: `${_constants.COMPARATOR_MAPPING[slo.indicator.params.metric.comparator]} ${threshold}`
    }],
    id: "thresholdShade",
    style: {
      fill: euiTheme.colors.warning,
      opacity: 0.1
    }
  }));
}