"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticsearchQueryOrThrow = getElasticsearchQueryOrThrow;
var _sloSchema = require("@kbn/slo-schema");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getElasticsearchQueryOrThrow(kuery = '') {
  try {
    if (_sloSchema.kqlQuerySchema.is(kuery)) {
      return (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kuery));
    } else {
      return (0, _esQuery.buildEsQuery)(undefined, {
        query: kuery === null || kuery === void 0 ? void 0 : kuery.kqlQuery,
        language: 'kuery'
      }, kuery === null || kuery === void 0 ? void 0 : kuery.filters);
    }
  } catch (err) {
    // @ts-expect-error `getElasticsearchQueryOrThrow` but it doesn't throw :shrug:
    return [];
  }
}