"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebCrawlersElasticManaged = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _i18n_string = require("../../../common/i18n_string");
var _use_kibana = require("../hooks/use_kibana");
var _elastic_managed_web_crawlers_empty_prompt = require("./web_crawlers/elastic_managed_web_crawlers_empty_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WebCrawlersElasticManaged = () => {
  const {
    console: consolePlugin
  } = (0, _use_kibana.useKibanaServices)();
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, null) : null, [consolePlugin]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    grow: true,
    restrictWidth: true,
    "data-test-subj": "svlSearchConnectorsPage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: _i18n.i18n.translate('xpack.serverlessSearch.webcrawlers.title', {
      defaultMessage: 'Web Crawlers'
    }),
    "data-test-subj": "serverlessSearchConnectorsTitle",
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.webcrawlers.headerContent",
    defaultMessage: "Discover extract and index searchable content from websites and knowledge bases {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "serverlessSearchConnectorsOverviewLink",
        external: true,
        target: "_blank",
        href: 'https://github.com/elastic/crawler'
      }, _i18n_string.LEARN_MORE_LABEL)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    restrictWidth: true,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_elastic_managed_web_crawlers_empty_prompt.ElasticManagedWebCrawlersEmptyPrompt, null)), embeddableConsole);
};
exports.WebCrawlersElasticManaged = WebCrawlersElasticManaged;