"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigFields = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _doc_links = require("../../../../../common/doc_links");
var _use_connector = require("../../../hooks/api/use_connector");
var _use_connector_configuration = require("../../../hooks/api/use_connector_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfigFields = ({
  connector,
  isDisabled
}) => {
  const {
    data,
    isLoading,
    isSuccess,
    mutate,
    reset
  } = (0, _use_connector_configuration.useEditConnectorConfiguration)(connector.id);
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  const queryClient = (0, _reactQuery.useQueryClient)();
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          configuration: data
        }
      });
      queryClient.invalidateQueries(queryKey);
      reset();
    }
  }, [data, isSuccess, connector, queryClient, queryKey, reset]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorConfigTitle', {
    defaultMessage: 'Configure your connector'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorConfigDescription', {
    defaultMessage: 'Your connector is set up. Now you can enter access details for your data source. This ensures the connector can find content and is authorized to access it.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_searchConnectors.ConnectorConfigurationComponent, {
    connector: connector,
    hasPlatinumLicense: false,
    isDisabled: isDisabled,
    isLoading: isLoading,
    saveConfig: mutate
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.searchConnectors.configurationConnector.config.documentation.description",
    defaultMessage: "This connector supports several authentication methods. Ask your administrator for the correct connection credentials. {documentationUrl}",
    values: {
      documentationUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        "data-test-subj": "serverlessSearchConnectorConfigFieldsDocumentationLink",
        href: _doc_links.docLinks.connectorClientAvailableConnectors
      }, _i18n.i18n.translate('xpack.serverlessSearch.searchConnectors.configurationConnector.config.documentation.link', {
        defaultMessage: 'Documentation'
      }))
    }
  }))));
};
exports.ConnectorConfigFields = ConnectorConfigFields;