"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsTaskService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rule_migrations_task_client = require("./rule_migrations_task_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleMigrationsTaskService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "migrationsRunning", void 0);
    this.logger = logger;
    this.migrationsRunning = new Map();
  }
  createClient({
    currentUser,
    dataClient,
    dependencies
  }) {
    return new _rule_migrations_task_client.RuleMigrationsTaskClient(this.migrationsRunning, this.logger, dataClient, currentUser, dependencies);
  }

  /** Stops all running migrations */
  stopAll() {
    this.migrationsRunning.forEach(migrationRunning => {
      migrationRunning.abortController.abort('Server shutdown');
    });
    this.migrationsRunning.clear();
  }
}
exports.RuleMigrationsTaskService = RuleMigrationsTaskService;