"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withLicense = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LICENSE_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.api.licenseError', {
  defaultMessage: 'Your license does not support this feature.'
});

/**
 * Wraps a request handler with a check for the license. If the license is not valid, it will
 * return a 403 error with a message.
 */
const withLicense = handler => {
  return async (context, req, res) => {
    const {
      license
    } = await context.licensing;
    if (!license.hasAtLeast('enterprise')) {
      return res.forbidden({
        body: LICENSE_ERROR_MESSAGE
      });
    }
    return handler(context, req, res);
  };
};
exports.withLicense = withLicense;