"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleEntityAnalyticsMigration = void 0;
var _schedule_ecs_compliancy_migration = require("../asset_criticality/migrations/schedule_ecs_compliancy_migration");
var _update_asset_criticality_mappings = require("../asset_criticality/migrations/update_asset_criticality_mappings");
var _update_risk_score_mappings = require("../risk_engine/migrations/update_risk_score_mappings");
var _rename_risk_score_component_templates = require("../risk_engine/migrations/rename_risk_score_component_templates");
var _event_ingested_pipeline = require("../utils/event_ingested_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * ### How to add a new field to the risk score index and template mappings?

 * - Update the mapping object [here](../risk_score/configurations.ts)
 * - Pump the `mappingsVersion` version [here](../risk_engine/utils/saved_object_configuration.ts)
 *
 * ### How to add a new field to the asset criticality index?
 * - Update the mapping object [here](../asset_criticality/constants.ts)
 * - Pump the `ASSET_CRITICALITY_MAPPINGS_VERSIONS` version [here](../asset_criticality/constants.ts)
 *
 * ### How to update the risk score transform config?
 * - Update the transform config [here](../risk_score/configurations.ts)
 * - Pump the `version` [here](../risk_score/configurations.ts)
 *
 * note: If you change the `latest` property, the transform will reinstall after the engine task runs.
 */
const scheduleEntityAnalyticsMigration = async params => {
  const paramsWithScopedLogger = {
    ...params,
    logger: params.logger.get('entityAnalytics.migration')
  };
  await (0, _event_ingested_pipeline.createEventIngestedPipelineInAllNamespaces)(paramsWithScopedLogger);
  await (0, _update_asset_criticality_mappings.updateAssetCriticalityMappings)(paramsWithScopedLogger);
  await (0, _schedule_ecs_compliancy_migration.scheduleAssetCriticalityEcsCompliancyMigration)(paramsWithScopedLogger);
  await (0, _rename_risk_score_component_templates.renameRiskScoreComponentTemplate)(paramsWithScopedLogger);
  await (0, _update_risk_score_mappings.updateRiskScoreMappings)(paramsWithScopedLogger);
};
exports.scheduleEntityAnalyticsMigration = scheduleEntityAnalyticsMigration;