"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidBooleanType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * validates ES boolean type
 */
const isValidBooleanType = boolean => {
  // boolean type reference https://www.elastic.co/guide/en/elasticsearch/reference/current/boolean.html
  const availableValues = ['true', 'false', true, false, ''];
  return availableValues.includes(boolean);
};
exports.isValidBooleanType = isValidBooleanType;