"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleSpacesClient = void 0;
var _event_log_constants = require("../../event_log/event_log_constants");
var _filters = require("../rule_objects/filters");
var _spaces = require("./aggregations/spaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Client for getting information about Kibana spaces in the context of detection rules.
 */

const createRuleSpacesClient = (currentSpaceId, internalSavedObjectsClient, logger) => {
  return {
    getCurrentSpaceId() {
      return currentSpaceId;
    },
    async getAllSpaceIds() {
      const aggs = (0, _spaces.getSpacesAggregation)();
      const response = await internalSavedObjectsClient.find({
        type: _event_log_constants.RULE_SAVED_OBJECT_TYPE,
        // query rules
        filter: _filters.DETECTION_RULES_FILTER,
        // make sure to query only detection rules
        namespaces: ['*'],
        // aggregate rules in all Kibana spaces
        perPage: 0,
        // don't return rules in the response, we only need aggs
        aggs
      });
      return (0, _spaces.normalizeSpacesAggregation)(response.aggregations);
    }
  };
};
exports.createRuleSpacesClient = createRuleSpacesClient;