"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrebuiltRuleBaseVersionHandler = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _lodash = require("lodash");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _utils = require("../../../routes/utils");
var _calculate_rule_diff = require("../../logic/diff/calculate_rule_diff");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _convert_prebuilt_rule_asset_to_rule_response = require("../../../rule_management/logic/detection_rules_client/converters/convert_prebuilt_rule_asset_to_rule_response");
var _get_rule_by_id = require("../../../rule_management/logic/detection_rules_client/methods/get_rule_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrebuiltRuleBaseVersionHandler = async (context, request, response) => {
  const siemResponse = (0, _utils.buildSiemResponse)(response);
  const {
    id
  } = request.query;
  try {
    const ctx = await context.resolve(['core', 'alerting']);
    const soClient = ctx.core.savedObjects.client;
    const rulesClient = await ctx.alerting.getRulesClient();
    const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(soClient);
    const currentRule = await (0, _get_rule_by_id.getRuleById)({
      rulesClient,
      id
    });
    if (!currentRule) {
      throw new Error(`Cannot find rule with id: ${id}`);
    }
    const [baseRule] = await ruleAssetsClient.fetchAssetsByVersion([currentRule]);
    if (!baseRule) {
      return siemResponse.error({
        body: 'Cannot find rule base_version',
        statusCode: 404
      });
    }
    const {
      ruleDiff
    } = (0, _calculate_rule_diff.calculateRuleDiff)({
      current: currentRule,
      base: baseRule,
      target: baseRule // We're using the base version as the target version as we want to revert the rule
    });
    const {
      diff,
      baseVersion,
      currentVersion
    } = formatDiffResponse({
      ruleDiff,
      baseRule,
      currentRule
    });
    const body = {
      diff,
      current_version: currentVersion,
      base_version: baseVersion
    };
    return response.ok({
      body
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    return siemResponse.error({
      body: error.message,
      statusCode: error.statusCode
    });
  }
};
exports.getPrebuiltRuleBaseVersionHandler = getPrebuiltRuleBaseVersionHandler;
const formatDiffResponse = ({
  ruleDiff,
  baseRule,
  currentRule
}) => {
  const baseVersion = {
    ...(0, _convert_prebuilt_rule_asset_to_rule_response.convertPrebuiltRuleAssetToRuleResponse)(baseRule),
    id: currentRule.id,
    // Set all fields to the original Elastic version values
    created_at: currentRule.created_at,
    created_by: currentRule.created_by,
    updated_at: currentRule.created_at,
    updated_by: currentRule.created_by,
    revision: 0
  };
  return {
    baseVersion,
    currentVersion: currentRule,
    diff: {
      ...ruleDiff,
      fields: (0, _lodash.pickBy)(ruleDiff.fields, fieldDiff => fieldDiff.diff_outcome === _prebuilt_rules.ThreeWayDiffOutcome.CustomizedValueNoUpdate)
    }
  };
};