"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Info = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InfoContainer = (0, _styled.default)(_eui.EuiText)`
  margin-right: ${({
  theme
}) => theme.euiTheme.size.s};
`;
const Label = _styled.default.span`
  font-weight: ${({
  theme
}) => theme.euiTheme.font.weight.bold};
  margin-right: ${({
  theme
}) => theme.euiTheme.size.xs};
`;
const Info = ({
  label,
  value
}) => /*#__PURE__*/_react.default.createElement(InfoContainer, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(Label, null, label, " "), " ", value);
exports.Info = Info;