"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformTimelineItemToUnifiedRows = transformTimelineItemToUnifiedRows;
var _dataService = require("@kbn/data-service");
var _constants = require("@kbn/unified-data-table/src/constants");
var _get_event_type_row_classname = require("./data_table/get_event_type_row_classname");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformTimelineItemToUnifiedRows(args) {
  const {
    events,
    dataView
  } = args;
  const rowClasses = {};
  const unifiedDataTableRows = events.map(({
    _id,
    _index,
    ecs,
    data
  }, index) => {
    const _source = ecs;
    const hit = {
      _id,
      _index: String(_index),
      _source
    };

    /**
     * Side effect
     * We need to add a custom className for each row based on the event type. Rather than looping twice
     * we take advantage of this map to set the styles for each row
     */
    rowClasses[index] = (0, _get_event_type_row_classname.getEventTypeRowClassName)(ecs);
    /*
     * Ideally for unified data table we only need raw and flattened keys
     * but we use this transformed data within other parts of security solution
     * so we create a combined data format for timeline item and DataTableRecord
     *
     * */
    return {
      _id,
      id: _id,
      data,
      ecs,
      raw: hit,
      flattened: (0, _dataService.flattenHit)(hit, dataView, {
        includeIgnoredValues: true
      })
    };
  });
  return {
    tableRows: unifiedDataTableRows,
    tableStylesOverride: {
      ..._constants.DATA_GRID_STYLE_DEFAULT,
      rowClasses
    }
  };
}