"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorEmptyPrompt = exports.EMPTY_PROMPT_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_PROMPT_TEST_ID = exports.EMPTY_PROMPT_TEST_ID = 'indicatorEmptyPrompt';
const IndicatorEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "warning",
  color: "danger",
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyoutTable.errorMessageTitle",
    defaultMessage: "Unable to display indicator information"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyoutTable.errorMessageBody",
    defaultMessage: "There was an error displaying the indicator fields and values."
  })),
  "data-test-subj": EMPTY_PROMPT_TEST_ID
});
exports.IndicatorEmptyPrompt = IndicatorEmptyPrompt;