"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMissingCapabilitiesToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMissingCapabilitiesToast = (missingCapabilities, core) => ({
  color: 'danger',
  iconType: 'alert',
  title: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.missingCapabilities.title', {
    defaultMessage: 'Insufficient privileges.'
  }),
  text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    "data-test-subj": "missingPrivilegesGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.missingCapabilities.description', {
    defaultMessage: 'The privileges required to start a rule migration are:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, /*#__PURE__*/_react.default.createElement("ul", null, missingCapabilities.map(({
    capability,
    description
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: capability
  }, description))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.missingCapabilities.contactAdministrator', {
    defaultMessage: 'Contact your administrator for assistance.'
  }))), core)
});
exports.getMissingCapabilitiesToast = getMissingCapabilitiesToast;