"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationRulesFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _status = require("./status");
var _author = require("./author");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrationRulesFilter = exports.MigrationRulesFilter = /*#__PURE__*/_react.default.memo(({
  filterOptions,
  onFilterOptionsChanged
}) => {
  const handleOnStatusChanged = (0, _react.useCallback)(newStatus => {
    onFilterOptionsChanged({
      ...filterOptions,
      ...{
        status: newStatus
      }
    });
  }, [filterOptions, onFilterOptionsChanged]);
  const handleOnAuthorChanged = (0, _react.useCallback)(newAuthor => {
    onFilterOptionsChanged({
      ...filterOptions,
      ...{
        author: newAuthor
      }
    });
  }, [filterOptions, onFilterOptionsChanged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_status.StatusFilterButton, {
    status: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.status,
    onStatusChanged: handleOnStatusChanged
  }), /*#__PURE__*/_react.default.createElement(_author.AuthorFilterButton, {
    author: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.author,
    onAuthorChanged: handleOnAuthorChanged
  }));
});
MigrationRulesFilter.displayName = 'MigrationRulesFilter';