"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPanelViewAndParameters = void 0;
var schema = _interopRequireWildcard(require("./schema"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validates an `unknown` value, narrowing it to `PanelViewAndParameters`.
 * Use this to validate that the value decoded from the URL is a valid `PanelViewAndParameters` object.
 */
const isPanelViewAndParameters = exports.isPanelViewAndParameters = schema.oneOf([schema.object({
  panelView: schema.literal('nodes')
}), schema.object({
  panelView: schema.literal('nodeDetail'),
  panelParameters: schema.object({
    nodeID: schema.string()
  })
}), schema.object({
  panelView: schema.literal('nodeEvents'),
  panelParameters: schema.object({
    nodeID: schema.string()
  })
}), schema.object({
  panelView: schema.literal('nodeEventsInCategory'),
  panelParameters: schema.object({
    nodeID: schema.string(),
    eventCategory: schema.string()
  })
}), schema.object({
  panelView: schema.literal('eventDetail'),
  panelParameters: schema.object({
    nodeID: schema.string(),
    eventCategory: schema.string(),
    eventID: schema.oneOf([schema.string(), schema.literal(undefined), schema.number()]),
    eventTimestamp: schema.string(),
    winlogRecordID: schema.string()
  })
})]);