"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INTEGRATION_TABS = void 0;
var _constants = require("../common/integrations/constants");
var _types = require("../../../../../common/lib/integrations/types");
var _use_enhanced_integration_cards = require("../../../../../common/lib/search_ai_lake/hooks/integrations/use_enhanced_integration_cards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_TABS = exports.INTEGRATION_TABS = [{
  category: '',
  id: _types.IntegrationTabId.recommendedSearchAILake,
  label: 'Recommended',
  overflow: 'scroll',
  showSearchTools: false,
  // Fleet has a default sorting for integrations by category that Security Solution does not want to apply
  // so we need to disable the sorting for the recommended tab to allow static ordering according to the featuredCardIds
  sortByFeaturedIntegrations: false,
  featuredCardIds: _use_enhanced_integration_cards.FEATURED_INTEGRATION_SORT_ORDER,
  height: `${_constants.INTEGRATION_CARD_HEIGHT * 1.8}px`
}];