"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedService = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../../../common/store");
var _manage_query = require("../../../../common/components/page/manage_query");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_first_last_seen = require("../../../../common/containers/use_first_last_seen");
var _helpers = require("../../../../helpers");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_security_default_patterns = require("../../../../data_view_manager/hooks/use_security_default_patterns");
var _store2 = require("../../../../sourcerer/store");
var _observed_service_details = require("./observed_service_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObservedService = (serviceName, scopeId) => {
  var _useSelector$patternL, _useSelector;
  const timelineTime = (0, _use_selector.useDeepEqualSelector)(state => _store.inputsSelectors.timelineTimeRangeSelector(state));
  const globalTime = (0, _use_global_time.useGlobalTime)();
  const isActiveTimelines = (0, _helpers.isActiveTimeline)(scopeId);
  const {
    to,
    from
  } = isActiveTimelines ? timelineTime : globalTime;
  const {
    isInitializing,
    setQuery,
    deleteQuery
  } = globalTime;
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const oldSecurityDefaultPatterns = (_useSelector$patternL = (_useSelector = (0, _reactRedux.useSelector)(_store2.sourcererSelectors.defaultDataView)) === null || _useSelector === void 0 ? void 0 : _useSelector.patternList) !== null && _useSelector$patternL !== void 0 ? _useSelector$patternL : [];
  const {
    indexPatterns: experimentalSecurityDefaultIndexPatterns
  } = (0, _use_security_default_patterns.useSecurityDefaultPatterns)();
  const securityDefaultPatterns = newDataViewPickerEnabled ? experimentalSecurityDefaultIndexPatterns : oldSecurityDefaultPatterns;
  const [loadingObservedService, {
    serviceDetails: observedServiceDetails,
    inspect,
    refetch,
    id: queryId
  }] = (0, _observed_service_details.useObservedServiceDetails)({
    endDate: to,
    startDate: from,
    serviceName,
    indexNames: securityDefaultPatterns,
    skip: isInitializing
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId,
    loading: loadingObservedService
  });
  const [loadingFirstSeen, {
    firstSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'service.name',
    value: serviceName,
    defaultIndex: securityDefaultPatterns,
    order: _search_strategy.Direction.asc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  const [loadingLastSeen, {
    lastSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'service.name',
    value: serviceName,
    defaultIndex: securityDefaultPatterns,
    order: _search_strategy.Direction.desc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  return (0, _react.useMemo)(() => ({
    details: observedServiceDetails,
    isLoading: loadingObservedService || loadingLastSeen || loadingFirstSeen,
    firstSeen: {
      date: firstSeen,
      isLoading: loadingFirstSeen
    },
    lastSeen: {
      date: lastSeen,
      isLoading: loadingLastSeen
    }
  }), [firstSeen, lastSeen, loadingFirstSeen, loadingLastSeen, loadingObservedService, observedServiceDetails]);
};
exports.useObservedService = useObservedService;