"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareFetchExceptionItemsParams = exports.getExceptionItemsReferences = exports.fetchListExceptionItems = exports.editException = exports.deleteException = exports.addException = void 0;
var _securitysolutionListApi = require("@kbn/securitysolution-list-api");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _api = require("../../detection_engine/rule_management/api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Some of the APIs here are already defined in Kbn packages, need to be refactored

const prepareFetchExceptionItemsParams = (exceptions, list, options) => {
  const {
    pagination,
    search,
    filters
  } = options || {};
  let listIds = [];
  let namespaceTypes = [];
  if (Array.isArray(exceptions) && exceptions.length) {
    listIds = exceptions.map(excList => excList.list_id);
    namespaceTypes = exceptions.map(excList => excList.namespace_type);
  } else if (list) {
    listIds = [list.list_id];
    namespaceTypes = [list.namespace_type];
  }
  return {
    listIds,
    namespaceTypes,
    pagination,
    search,
    filters
  };
};
exports.prepareFetchExceptionItemsParams = prepareFetchExceptionItemsParams;
const fetchListExceptionItems = async ({
  namespaceTypes,
  listIds,
  http,
  pagination,
  search
}) => {
  try {
    const abortCtrl = new AbortController();
    const {
      pageIndex: inputPageIndex,
      pageSize: inputPageSize,
      totalItemCount: inputTotalItemCount
    } = pagination || {};

    // TODO transform Pagination object from Frontend=>Backend & <=
    const {
      page: pageIndex,
      per_page: pageSize,
      total: totalItemCount,
      data
    } = await (0, _securitysolutionListApi.fetchExceptionListsItemsByListIds)({
      filter: undefined,
      http: http,
      listIds: listIds !== null && listIds !== void 0 ? listIds : [],
      namespaceTypes: namespaceTypes !== null && namespaceTypes !== void 0 ? namespaceTypes : [],
      search,
      pagination: {
        perPage: inputPageSize,
        page: (inputPageIndex || 0) + 1,
        total: inputTotalItemCount
      },
      signal: abortCtrl.signal
    });
    const transformedData = data.map(item => (0, _securitysolutionListHooks.transformInput)(item));
    return {
      data: transformedData,
      pagination: {
        pageIndex: pageIndex - 1,
        pageSize,
        totalItemCount
      }
    };
  } catch (error) {
    throw new Error(error);
  }
};
exports.fetchListExceptionItems = fetchListExceptionItems;
const getExceptionItemsReferences = async lists => {
  try {
    const abortCtrl = new AbortController();
    const {
      references
    } = await (0, _api.findRuleExceptionReferences)({
      lists: lists.map(listInput => ({
        id: listInput.id,
        listId: listInput.list_id,
        namespaceType: listInput.namespace_type
      })),
      signal: abortCtrl.signal
    });
    return references.reduce((acc, reference) => {
      return {
        ...acc,
        ...reference
      };
    }, {});
  } catch (error) {
    throw new Error(error);
  }
};
exports.getExceptionItemsReferences = getExceptionItemsReferences;
const deleteException = async ({
  id,
  namespaceType,
  http
}) => {
  try {
    const abortCtrl = new AbortController();
    await (0, _securitysolutionListApi.deleteExceptionListItemById)({
      http: http,
      id,
      namespaceType,
      signal: abortCtrl.signal
    });
  } catch (error) {
    throw new Error(error);
  }
};
exports.deleteException = deleteException;
const editException = async ({
  http,
  exception
}) => {
  try {
    const abortCtrl = new AbortController();
    await (0, _securitysolutionListApi.updateExceptionListItem)({
      http: http,
      listItem: exception,
      signal: abortCtrl.signal
    });
  } catch (error) {
    throw new Error(error);
  }
};
exports.editException = editException;
const addException = async ({
  http,
  exception
}) => {
  try {
    const abortCtrl = new AbortController();
    await (0, _securitysolutionListApi.addExceptionListItem)({
      http: http,
      listItem: exception,
      signal: abortCtrl.signal
    });
  } catch (error) {
    throw new Error(error);
  }
};
exports.addException = addException;