"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionSeverityFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedAccessDetectionSeverityFilter = ({
  anomalyBands,
  toggleHiddenBand
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement("p", {
    css: {
      fontWeight: euiTheme.font.weight.bold
    }
  }, 'Anomaly score'), anomalyBands.map(band => {
    if (band.hidden) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: `${band.start}-${band.end}`,
        css: {
          cursor: 'pointer'
        },
        onClick: () => toggleHiddenBand(band),
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: 'center',
        gutterSize: 'xs'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: 'eyeClosed'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: euiTheme.colors.textSubdued
      }, /*#__PURE__*/_react.default.createElement("p", null, `${band.start}-${band.end}`))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      key: `${band.start}-${band.end}`,
      css: {
        cursor: 'pointer'
      },
      onClick: () => toggleHiddenBand(band),
      color: band.color
    }, `${band.start}-${band.end}`);
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null));
};
exports.PrivilegedAccessDetectionSeverityFilter = PrivilegedAccessDetectionSeverityFilter;