"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskInputsUtilityBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_risk_input_actions_panels = require("../hooks/use_risk_input_actions_panels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskInputsUtilityBar = exports.RiskInputsUtilityBar = /*#__PURE__*/_react.default.memo(({
  riskInputs
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const panels = (0, _use_risk_input_actions_panels.useRiskInputActionsPanels)(riskInputs, closePopover);
  if (riskInputs.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "risk-input-utility-bar",
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            padding: ${euiTheme.size.s} 0;
          `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: togglePopover,
      size: "xs",
      iconSide: "right",
      iconType: "arrowDown",
      flush: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.utilityBar.text",
      defaultMessage: "{totalSelectedContributions} selected risk contribution",
      values: {
        totalSelectedContributions: riskInputs.length
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: 0
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
});
RiskInputsUtilityBar.displayName = 'RiskInputsUtilityBar';