"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionEngineUserUnauthenticated = void 0;
var _react = _interopRequireWildcard(require("react"));
var _empty_page = require("../../../common/components/empty_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectionEngineUserUnauthenticated = exports.DetectionEngineUserUnauthenticated = /*#__PURE__*/_react.default.memo(() => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  const actions = (0, _react.useMemo)(() => ({
    detectionUnauthenticated: {
      icon: 'documents',
      label: i18n.GO_TO_DOCUMENTATION,
      url: `${docLinks.links.siem.detectionsReq}`,
      target: '_blank'
    }
  }), [docLinks]);
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: actions,
    message: i18n.USER_UNAUTHENTICATED_MSG_BODY,
    "data-test-subj": "no_index",
    title: i18n.USER_UNAUTHENTICATED_TITLE
  });
});
DetectionEngineUserUnauthenticated.displayName = 'DetectionEngineUserUnauthenticated';