"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewDashboard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _links_to_docs = require("../../../../common/components/links_to_docs");
var _header_page = require("../../../../common/components/header_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _tactic_panel = require("./tactic_panel");
var _technique_panel_popover = require("./technique_panel_popover");
var _filters_panel = require("./filters_panel");
var _coverage_overview_dashboard_context = require("./coverage_overview_dashboard_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewHeaderComponent = () => /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
  title: i18n.COVERAGE_OVERVIEW_DASHBOARD_TITLE,
  subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.CoverageOverviewDashboardInformation), " ", /*#__PURE__*/_react.default.createElement(_links_to_docs.CoverageOverviewLink, null))
});
const CoverageOverviewHeader = /*#__PURE__*/_react.default.memo(CoverageOverviewHeaderComponent);
const CoverageOverviewDashboardComponent = () => {
  const {
    state: {
      data
    }
  } = (0, _coverage_overview_dashboard_context.useCoverageOverviewDashboardContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CoverageOverviewHeader, null), /*#__PURE__*/_react.default.createElement(_filters_panel.CoverageOverviewFiltersPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    className: "eui-xScroll",
    tabIndex: 0
  }, data === null || data === void 0 ? void 0 : data.mitreTactics.map(tactic => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `coverageOverviewTacticGroup-${tactic.id}`,
    direction: "column",
    key: tactic.id,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tactic_panel.CoverageOverviewTacticPanel, {
    tactic: tactic
  })), tactic.techniques.map((technique, techniqueKey) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${technique.id}-${techniqueKey}`
  }, /*#__PURE__*/_react.default.createElement(_technique_panel_popover.CoverageOverviewMitreTechniquePanelPopover, {
    technique: technique
  })))))));
};
const CoverageOverviewDashboard = exports.CoverageOverviewDashboard = CoverageOverviewDashboardComponent;