"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchRuleFieldReadOnly = ThreatMatchRuleFieldReadOnly;
var _react = _interopRequireDefault(require("react"));
var _data_source = require("./fields/data_source/data_source");
var _kql_query = require("./fields/kql_query");
var _threat_index = require("./fields/threat_index/threat_index");
var _threat_indicator_path = require("./fields/threat_indicator_path/threat_indicator_path");
var _threat_mapping = require("./fields/threat_mapping/threat_mapping");
var _threat_query = require("./fields/threat_query/threat_query");
var _type = require("./fields/type/type");
var _alert_suppression = require("./fields/alert_suppression/alert_suppression");
var _utility_types = require("../../../../../../../common/utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ThreatMatchRuleFieldReadOnly({
  fieldName,
  finalDiffableRule
}) {
  switch (fieldName) {
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionReadOnly, {
        alertSuppression: finalDiffableRule.alert_suppression,
        ruleType: finalDiffableRule.type
      });
    case 'data_source':
      return /*#__PURE__*/_react.default.createElement(_data_source.DataSourceReadOnly, {
        dataSource: finalDiffableRule.data_source
      });
    case 'kql_query':
      return /*#__PURE__*/_react.default.createElement(_kql_query.KqlQueryReadOnly, {
        kqlQuery: finalDiffableRule.kql_query,
        dataSource: finalDiffableRule.data_source,
        ruleType: finalDiffableRule.type
      });
    case 'threat_index':
      return /*#__PURE__*/_react.default.createElement(_threat_index.ThreatIndexReadOnly, {
        threatIndex: finalDiffableRule.threat_index
      });
    case 'threat_indicator_path':
      return /*#__PURE__*/_react.default.createElement(_threat_indicator_path.ThreatIndicatorPathReadOnly, {
        threatIndicatorPath: finalDiffableRule.threat_indicator_path
      });
    case 'threat_mapping':
      return /*#__PURE__*/_react.default.createElement(_threat_mapping.ThreatMappingReadOnly, {
        threatMapping: finalDiffableRule.threat_mapping
      });
    case 'threat_query':
      return /*#__PURE__*/_react.default.createElement(_threat_query.ThreatQueryReadOnly, {
        threatQuery: finalDiffableRule.threat_query,
        dataSource: finalDiffableRule.data_source
      });
    case 'type':
      return /*#__PURE__*/_react.default.createElement(_type.TypeReadOnly, {
        type: finalDiffableRule.type
      });
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}