"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseRuleIndexPatternParameters = getUseRuleIndexPatternParameters;
var _types = require("../../../../../common/types");
var _detection_engine = require("../../../../../../../common/api/detection_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getUseRuleIndexPatternParameters(finalDiffableRule, defaultIndexPattern) {
  if (!('data_source' in finalDiffableRule) || !finalDiffableRule.data_source) {
    return {
      dataSourceType: _types.DataSourceType.IndexPatterns,
      index: defaultIndexPattern,
      dataViewId: undefined
    };
  }
  if (finalDiffableRule.data_source.type === _detection_engine.DataSourceType.data_view) {
    return {
      dataSourceType: _types.DataSourceType.DataView,
      index: [],
      dataViewId: finalDiffableRule.data_source.data_view_id
    };
  }
  return {
    dataSourceType: _types.DataSourceType.IndexPatterns,
    index: finalDiffableRule.data_source.index_patterns,
    dataViewId: undefined
  };
}