"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BULK_FILL_RULE_GAPS_TIME_RANGE_TITLE = exports.BULK_FILL_RULE_GAPS_START_DATE_OUT_OF_RANGE_ERROR = exports.BULK_FILL_RULE_GAPS_START_AT_TITLE = exports.BULK_FILL_RULE_GAPS_NOTIFICATIONS_LIMITATIONS = exports.BULK_FILL_RULE_GAPS_MODAL_TITLE = exports.BULK_FILL_RULE_GAPS_MAX_GAPS_LIMITATIONS = exports.BULK_FILL_RULE_GAPS_INVALID_TIME_RANGE_ERROR = exports.BULK_FILL_RULE_GAPS_FUTURE_TIME_RANGE_ERROR = exports.BULK_FILL_RULE_GAPS_END_AT_TITLE = exports.BULK_FILL_RULE_GAPS_CONFIRM_BUTTON = exports.BULK_FILL_RULE_GAPS_CANCEL_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BULK_FILL_RULE_GAPS_MODAL_TITLE = exports.BULK_FILL_RULE_GAPS_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.modalTitle', {
  defaultMessage: 'Schedule gap fills'
});
const BULK_FILL_RULE_GAPS_TIME_RANGE_TITLE = exports.BULK_FILL_RULE_GAPS_TIME_RANGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.timeRangeTitle', {
  defaultMessage: 'Select a time range for gap fills'
});
const BULK_FILL_RULE_GAPS_START_AT_TITLE = exports.BULK_FILL_RULE_GAPS_START_AT_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.startAtTitle', {
  defaultMessage: 'Start at'
});
const BULK_FILL_RULE_GAPS_END_AT_TITLE = exports.BULK_FILL_RULE_GAPS_END_AT_TITLE = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.endAtTitle', {
  defaultMessage: 'Finish at'
});
const BULK_FILL_RULE_GAPS_CONFIRM_BUTTON = exports.BULK_FILL_RULE_GAPS_CONFIRM_BUTTON = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.confirmButton', {
  defaultMessage: 'Schedule gap fills'
});
const BULK_FILL_RULE_GAPS_CANCEL_BUTTON = exports.BULK_FILL_RULE_GAPS_CANCEL_BUTTON = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.cancelButton', {
  defaultMessage: 'Cancel'
});
const BULK_FILL_RULE_GAPS_INVALID_TIME_RANGE_ERROR = exports.BULK_FILL_RULE_GAPS_INVALID_TIME_RANGE_ERROR = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.invalidTimeRangeError', {
  defaultMessage: 'Selected time range is invalid'
});
const BULK_FILL_RULE_GAPS_FUTURE_TIME_RANGE_ERROR = exports.BULK_FILL_RULE_GAPS_FUTURE_TIME_RANGE_ERROR = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.futureTimeRangeError', {
  defaultMessage: 'Select a different time range. Future gap fills are not supported.'
});
const BULK_FILL_RULE_GAPS_START_DATE_OUT_OF_RANGE_ERROR = maxDaysLookback => _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.startDateIsOutOfRangeError', {
  values: {
    maxDaysLookback
  },
  defaultMessage: 'Rule gap fills cannot be scheduled earlier than {maxDaysLookback, plural, =1 {# day} other {# days}} ago'
});
exports.BULK_FILL_RULE_GAPS_START_DATE_OUT_OF_RANGE_ERROR = BULK_FILL_RULE_GAPS_START_DATE_OUT_OF_RANGE_ERROR;
const BULK_FILL_RULE_GAPS_NOTIFICATIONS_LIMITATIONS = exports.BULK_FILL_RULE_GAPS_NOTIFICATIONS_LIMITATIONS = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.notificationsLimitations', {
  defaultMessage: 'Alert summary rule actions that run at a custom frequency are not performed during manual runs started by gap fills.'
});
const BULK_FILL_RULE_GAPS_MAX_GAPS_LIMITATIONS = exports.BULK_FILL_RULE_GAPS_MAX_GAPS_LIMITATIONS = _i18n.i18n.translate('xpack.securitySolution.bulkFillRuleGapsModal.maxGapsLimitations', {
  defaultMessage: 'A maximum of 1000 gaps will be filled per rule.'
});