"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleRuleRunMutation = exports.SCHEDULE_RULE_RUN_MUTATION_KEY = void 0;
var _common = require("@kbn/alerting-plugin/common");
var _reactQuery = require("@kbn/react-query");
var _api = require("../api");
var _use_find_backfills_for_rules = require("./use_find_backfills_for_rules");
var _use_find_gaps_for_rule = require("./use_find_gaps_for_rule");
var _use_get_rule_ids_with_gaps = require("./use_get_rule_ids_with_gaps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULE_RULE_RUN_MUTATION_KEY = exports.SCHEDULE_RULE_RUN_MUTATION_KEY = ['POST', _common.INTERNAL_ALERTING_BACKFILL_SCHEDULE_API_PATH];
const useScheduleRuleRunMutation = options => {
  const invalidateBackfillQuery = (0, _use_find_backfills_for_rules.useInvalidateFindBackfillQuery)();
  const invalidateFindGapsQuery = (0, _use_find_gaps_for_rule.useInvalidateFindGapsQuery)();
  const invalidateGetRuleIdsWithGapsQuery = (0, _use_get_rule_ids_with_gaps.useInvalidateGetRuleIdsWithGapsQuery)();
  return (0, _reactQuery.useMutation)(scheduleOptions => (0, _api.scheduleRuleRun)(scheduleOptions), {
    ...options,
    onSettled: (...args) => {
      invalidateBackfillQuery();
      invalidateFindGapsQuery();
      invalidateGetRuleIdsWithGapsQuery();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    },
    mutationKey: SCHEDULE_RULE_RUN_MUTATION_KEY
  });
};
exports.useScheduleRuleRunMutation = useScheduleRuleRunMutation;