"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* istanbul ignore file */

const schema = exports.schema = {
  interval: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.fieldIntervalLabel', {
      defaultMessage: 'Runs every'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.fieldIntervalHelpText', {
      defaultMessage: 'Rules run periodically and detect alerts within the specified time frame.'
    })
  },
  from: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.fieldAdditionalLookBackLabel', {
      defaultMessage: 'Additional look-back time'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.fieldAdditionalLookBackHelpText', {
      defaultMessage: 'Adds time to the look-back period to prevent missed alerts.'
    })
  }
};